/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.store.contracts.utils;

import com.hedera.node.app.service.evm.store.contracts.precompile.codec.ExplicitRedirectForTokenWrapper;
import com.hedera.node.app.service.evm.store.contracts.precompile.impl.EvmRedirectForTokenPrecompile;
import com.hedera.node.app.service.evm.store.contracts.precompile.proxy.RedirectTarget;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;

public class DescriptorUtils {
    public static final long MINIMUM_TINYBARS_COST = 100L;
    public static final int ADDRESS_BYTES_LENGTH = 20;
    public static final int ADDRESS_SKIP_BYTES_LENGTH = 12;

    private DescriptorUtils() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static boolean isTokenProxyRedirect(Bytes input) {
        return 1636681310 == input.getInt(0);
    }

    public static boolean isViewFunction(Bytes input) {
        int functionId = input.getInt(0);
        return switch (functionId) {
            case -1826149457, -1478844019, -1367993952, -703279688, -222093324, 435385185, 526997087, 679353768, 861799617, 1011733294, 1059627419, 1188958129 -> true;
            default -> false;
        };
    }

    public static RedirectTarget getRedirectTarget(Bytes input) {
        Bytes finalInput = DescriptorUtils.massageInputIfNeeded(input);
        Bytes tokenBytes = finalInput.slice(4, 20);
        Address tokenAddress = Address.wrap((Bytes)Bytes.wrap((byte[])tokenBytes.toArrayUnsafe()));
        Bytes nestedInput = finalInput.slice(24);
        return new RedirectTarget(nestedInput.getInt(0), tokenAddress, (Bytes)(finalInput != input ? finalInput : null));
    }

    public static Address addressFromBytes(byte[] addressBytes) {
        Bytes bytes = Bytes.wrap((byte[])addressBytes);
        if (addressBytes.length > 20) {
            bytes = bytes.slice(12, 20);
        }
        return Address.wrap((Bytes)bytes);
    }

    private static Bytes massageInputIfNeeded(Bytes input) {
        try {
            ExplicitRedirectForTokenWrapper<byte[], byte[]> redirectForTokenWrapper = EvmRedirectForTokenPrecompile.decodeExplicitRedirectForToken(input);
            return Bytes.concatenate((Bytes[])new Bytes[]{Bytes.ofUnsignedInt((long)1636681310L), DescriptorUtils.addressFromBytes(redirectForTokenWrapper.token()), Bytes.of((byte[])redirectForTokenWrapper.data())});
        }
        catch (Exception e) {
            return input;
        }
    }
}

