/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.store.models;

import com.google.common.base.MoreObjects;
import com.google.protobuf.ByteString;
import com.hedera.node.app.service.evm.utils.EthSigsUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;

public class HederaEvmAccount {
    public static final ByteString ECDSA_KEY_ALIAS_PREFIX = ByteString.copyFrom((byte[])new byte[]{58, 33});
    public static final int EVM_ADDRESS_SIZE = 20;
    public static final int ECDSA_SECP256K1_ALIAS_SIZE = 35;
    protected final Address address;
    protected ByteString alias = ByteString.EMPTY;

    public HederaEvmAccount(Address address) {
        this.address = address;
    }

    public void setAlias(ByteString alias) {
        this.alias = alias;
    }

    public ByteString getAlias() {
        return this.alias;
    }

    public Address canonicalAddress() {
        if (this.alias.isEmpty()) {
            return this.address;
        }
        if (this.alias.size() == 20) {
            return Address.wrap((Bytes)Bytes.wrap((byte[])this.alias.toByteArray()));
        }
        if (this.alias.size() == 35 && this.alias.startsWith(ECDSA_KEY_ALIAS_PREFIX)) {
            byte[] addressBytes = EthSigsUtils.recoverAddressFromPubKey(this.alias.substring(2).toByteArray());
            return addressBytes.length == 0 ? this.address : Address.wrap((Bytes)Bytes.wrap((byte[])addressBytes));
        }
        return this.address;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return MoreObjects.toStringHelper(HederaEvmAccount.class).add("address", (Object)this.address.toHexString()).add("alias", (Object)this.getAlias().toStringUtf8()).toString();
    }
}

