/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.contracts.operations;

import com.hedera.node.app.service.evm.contracts.execution.EvmProperties;
import com.hedera.node.app.service.evm.contracts.operations.AbstractEvmRecordingCreateOperation;
import com.hedera.node.app.service.evm.contracts.operations.CreateOperationExternalizer;
import com.hedera.node.app.service.evm.store.contracts.HederaEvmStackedWorldUpdater;
import javax.inject.Inject;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;

public class HederaEvmCreate2Operation
extends AbstractEvmRecordingCreateOperation {
    protected final EvmProperties evmProperties;
    private static final Bytes PREFIX = Bytes.fromHexString((CharSequence)"0xFF");

    @Inject
    public HederaEvmCreate2Operation(GasCalculator gasCalculator, EvmProperties evmProperties, CreateOperationExternalizer createOperationExternalizer) {
        super(245, "\u0127CREATE2", 4, 1, gasCalculator, createOperationExternalizer);
        this.evmProperties = evmProperties;
    }

    @Override
    public boolean isEnabled() {
        return this.evmProperties.isCreate2Enabled();
    }

    @Override
    public long cost(MessageFrame frame) {
        return this.gasCalculator().create2OperationGasCost(frame);
    }

    @Override
    public Address targetContractAddress(MessageFrame frame) {
        Address sourceAddressOrAlias = frame.getRecipientAddress();
        long offset = Words.clampedToLong((Bytes)frame.getStackItem(1));
        long length = Words.clampedToLong((Bytes)frame.getStackItem(2));
        HederaEvmStackedWorldUpdater updater = (HederaEvmStackedWorldUpdater)frame.getWorldUpdater();
        Address source = updater.priorityAddress(sourceAddressOrAlias);
        UInt256 salt = UInt256.fromBytes((Bytes)frame.getStackItem(3));
        MutableBytes initCode = frame.readMutableMemory(offset, length);
        Bytes32 hash = HederaEvmCreate2Operation.keccak256(Bytes.concatenate((Bytes[])new Bytes[]{PREFIX, source, salt, HederaEvmCreate2Operation.keccak256((Bytes)initCode)}));
        Address alias = Address.wrap((Bytes)hash.slice(12, 20));
        Address address = updater.newAliasedContractAddress(sourceAddressOrAlias, alias);
        frame.warmUpAddress(address);
        frame.warmUpAddress(alias);
        return alias;
    }

    public static Bytes32 keccak256(Bytes input) {
        return Bytes32.wrap((byte[])HederaEvmCreate2Operation.keccak256DigestOf(input.toArrayUnsafe()));
    }

    private static byte[] keccak256DigestOf(byte[] msg) {
        return new Keccak.Digest256().digest(msg);
    }
}

