/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.contracts.operations;

import com.hedera.node.app.service.evm.contracts.operations.HederaEvmOperationsUtil;
import java.util.function.BiPredicate;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.ExtCodeCopyOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class HederaExtCodeCopyOperation
extends ExtCodeCopyOperation {
    private final BiPredicate<Address, MessageFrame> addressValidator;

    public HederaExtCodeCopyOperation(GasCalculator gasCalculator, BiPredicate<Address, MessageFrame> addressValidator) {
        super(gasCalculator);
        this.addressValidator = addressValidator;
    }

    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        long memOffset = Words.clampedToLong((Bytes)frame.getStackItem(1));
        long numBytes = Words.clampedToLong((Bytes)frame.getStackItem(3));
        return HederaEvmOperationsUtil.addressCheckExecution(frame, () -> frame.getStackItem(0), () -> this.cost(frame, memOffset, numBytes, true), () -> super.execute(frame, evm), this.addressValidator);
    }
}

