/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.contracts.operations;

import com.hedera.node.app.service.evm.contracts.operations.HederaExceptionalHaltReason;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.FixedStack;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.ExtCodeHashOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class HederaExtCodeHashOperationV038
extends ExtCodeHashOperation {
    private final BiPredicate<Address, MessageFrame> addressValidator;
    private final Predicate<Address> systemAccountDetector;

    public HederaExtCodeHashOperationV038(GasCalculator gasCalculator, BiPredicate<Address, MessageFrame> addressValidator, Predicate<Address> systemAccountDetector) {
        super(gasCalculator);
        this.addressValidator = addressValidator;
        this.systemAccountDetector = systemAccountDetector;
    }

    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        try {
            Address address = Words.toAddress((Bytes)frame.popStackItem());
            if (this.systemAccountDetector.test(address)) {
                frame.pushStackItem((Bytes)UInt256.ZERO);
                return new Operation.OperationResult(this.cost(true), null);
            }
            if (!this.addressValidator.test(address, frame)) {
                return new Operation.OperationResult(this.cost(true), HederaExceptionalHaltReason.INVALID_SOLIDITY_ADDRESS);
            }
            Account account = frame.getWorldUpdater().get(address);
            boolean accountIsWarm = frame.warmUpAddress(address) || this.gasCalculator().isPrecompile(address);
            long localCost = this.cost(accountIsWarm);
            if (frame.getRemainingGas() < localCost) {
                return new Operation.OperationResult(localCost, ExceptionalHaltReason.INSUFFICIENT_GAS);
            }
            if (!account.isEmpty()) {
                frame.pushStackItem((Bytes)UInt256.fromBytes((Bytes)account.getCodeHash()));
            } else {
                frame.pushStackItem((Bytes)UInt256.ZERO);
            }
            return new Operation.OperationResult(localCost, null);
        }
        catch (FixedStack.UnderflowException ufe) {
            return new Operation.OperationResult(this.cost(true), ExceptionalHaltReason.INSUFFICIENT_STACK_ITEMS);
        }
        catch (FixedStack.OverflowException ofe) {
            return new Operation.OperationResult(this.cost(true), ExceptionalHaltReason.TOO_MANY_STACK_ITEMS);
        }
    }
}

