/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.utils;

import com.hedera.node.app.service.evm.exceptions.InvalidTransactionException;
import com.hederahashgraph.api.proto.java.ResponseCodeEnum;
import java.util.function.Supplier;

public final class ValidationUtils {
    private ValidationUtils() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static void validateTrue(boolean flag, ResponseCodeEnum code) {
        if (!flag) {
            throw new InvalidTransactionException(code);
        }
    }

    public static void validateTrueOrRevert(boolean flag, ResponseCodeEnum code) {
        if (!flag) {
            throw new InvalidTransactionException(code, true);
        }
    }

    public static void validateTrue(boolean flag, ResponseCodeEnum code, String failureMsg) {
        if (!flag) {
            throw new InvalidTransactionException(failureMsg, code);
        }
    }

    public static void validateTrue(boolean flag, ResponseCodeEnum code, Supplier<String> failureMsg) {
        if (!flag) {
            throw new InvalidTransactionException(failureMsg.get(), code);
        }
    }

    public static void validateFalse(boolean flag, ResponseCodeEnum code) {
        if (flag) {
            throw new InvalidTransactionException(code);
        }
    }

    public static void validateFalse(boolean flag, ResponseCodeEnum code, String failureMsg) {
        if (flag) {
            throw new InvalidTransactionException(failureMsg, code);
        }
    }

    public static void validateFalse(boolean flag, ResponseCodeEnum code, Supplier<String> failureMsg) {
        if (flag) {
            throw new InvalidTransactionException(failureMsg.get(), code);
        }
    }

    public static void validateFalseOrRevert(boolean flag, ResponseCodeEnum code) {
        if (flag) {
            throw new InvalidTransactionException(code, true);
        }
    }
}

