/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.contracts.execution;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.node.app.service.evm.contracts.execution.BlockMetaSource;
import com.hedera.node.app.service.evm.contracts.execution.EvmProperties;
import com.hedera.node.app.service.evm.contracts.execution.HederaEvmTransactionProcessingResult;
import com.hedera.node.app.service.evm.contracts.execution.PricesAndFeesProvider;
import com.hedera.node.app.service.evm.contracts.execution.traceability.HederaEvmOperationTracer;
import com.hedera.node.app.service.evm.store.contracts.HederaEvmMutableWorldState;
import com.hedera.node.app.service.evm.store.contracts.HederaEvmWorldUpdater;
import com.hedera.node.app.service.evm.store.models.HederaEvmAccount;
import com.hederahashgraph.api.proto.java.HederaFunctionality;
import java.time.Instant;
import java.util.Deque;
import java.util.Map;
import javax.inject.Provider;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.frame.BlockValues;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.processor.AbstractMessageProcessor;
import org.hyperledger.besu.evm.processor.ContractCreationProcessor;
import org.hyperledger.besu.evm.processor.MessageCallProcessor;
import org.hyperledger.besu.evm.tracing.OperationTracer;
import org.hyperledger.besu.evm.worldstate.WorldUpdater;

public abstract class HederaEvmTxProcessor {
    private static final int MAX_STACK_SIZE = 1024;
    protected BlockMetaSource blockMetaSource;
    protected HederaEvmMutableWorldState worldState;
    protected GasCalculator gasCalculator;
    protected final PricesAndFeesProvider livePricesSource;
    protected final Map<String, Provider<MessageCallProcessor>> mcps;
    protected final Map<String, Provider<ContractCreationProcessor>> ccps;
    protected AbstractMessageProcessor messageCallProcessor;
    protected AbstractMessageProcessor contractCreationProcessor;
    protected HederaEvmOperationTracer tracer;
    protected EvmProperties dynamicProperties;
    protected Address coinbase;
    protected HederaEvmWorldUpdater updater;
    protected long intrinsicGas;
    protected MessageFrame initialFrame;
    protected long gasUsed;
    protected long sbhRefund;

    public void setBlockMetaSource(BlockMetaSource blockMetaSource) {
        this.blockMetaSource = blockMetaSource;
    }

    public void setWorldState(HederaEvmMutableWorldState worldState) {
        this.worldState = worldState;
    }

    public void setOperationTracer(HederaEvmOperationTracer tracer) {
        this.tracer = tracer;
    }

    protected HederaEvmTxProcessor(HederaEvmMutableWorldState worldState, PricesAndFeesProvider livePricesSource, EvmProperties dynamicProperties, GasCalculator gasCalculator, Map<String, Provider<MessageCallProcessor>> mcps, Map<String, Provider<ContractCreationProcessor>> ccps, BlockMetaSource blockMetaSource) {
        this.worldState = worldState;
        this.livePricesSource = livePricesSource;
        this.dynamicProperties = dynamicProperties;
        this.gasCalculator = gasCalculator;
        this.mcps = mcps;
        this.ccps = ccps;
        this.messageCallProcessor = (AbstractMessageProcessor)mcps.get(dynamicProperties.evmVersion()).get();
        this.contractCreationProcessor = (AbstractMessageProcessor)ccps.get(dynamicProperties.evmVersion()).get();
        this.blockMetaSource = blockMetaSource;
    }

    public HederaEvmTransactionProcessingResult execute(HederaEvmAccount sender, Address receiver, long gasPrice, long gasLimit, long value, Bytes payload, boolean isStatic, Address mirrorReceiver) {
        BlockValues blockValues = this.blockMetaSource.computeBlockValues(gasLimit);
        long gasAvailable = gasLimit - this.intrinsicGas;
        Wei valueAsWei = Wei.of((long)value);
        WorldUpdater stackedUpdater = this.updater.updater();
        Address senderEvmAddress = sender.canonicalAddress();
        MessageFrame.Builder commonInitialFrame = MessageFrame.builder().maxStackSize(1024).worldUpdater(stackedUpdater).initialGas(gasAvailable).originator(senderEvmAddress).gasPrice(Wei.of((long)gasPrice)).sender(senderEvmAddress).value(valueAsWei).apparentValue(valueAsWei).blockValues(blockValues).completer(unused -> {}).isStatic(isStatic).miningBeneficiary(this.coinbase).blockHashLookup(this.blockMetaSource::getBlockHash).contextVariables(Map.of("HederaFunctionality", this.getFunctionType()));
        this.initialFrame = this.buildInitialFrame(commonInitialFrame, receiver, payload, value);
        Deque messageFrameStack = this.initialFrame.getMessageFrameStack();
        this.tracer.init(this.initialFrame);
        if (this.dynamicProperties.dynamicEvmVersion()) {
            String evmVersion = this.dynamicProperties.evmVersion();
            this.messageCallProcessor = (AbstractMessageProcessor)this.mcps.get(evmVersion).get();
            this.contractCreationProcessor = (AbstractMessageProcessor)this.ccps.get(evmVersion).get();
        }
        while (!messageFrameStack.isEmpty()) {
            this.process((MessageFrame)messageFrameStack.peekFirst(), this.tracer);
        }
        this.gasUsed = this.calculateGasUsedByTX(gasLimit, this.initialFrame);
        this.sbhRefund = this.updater.getSbhRefund();
        this.tracer.finalizeOperation(this.initialFrame);
        if (this.initialFrame.getState() == MessageFrame.State.COMPLETED_SUCCESS) {
            return HederaEvmTransactionProcessingResult.successful(this.initialFrame.getLogs(), this.gasUsed, this.sbhRefund, gasPrice, this.initialFrame.getOutputData(), mirrorReceiver);
        }
        return HederaEvmTransactionProcessingResult.failed(this.gasUsed, this.sbhRefund, gasPrice, this.initialFrame.getRevertReason(), this.initialFrame.getExceptionalHaltReason());
    }

    public void setupFields(Bytes payload, boolean contractCreation) {
        this.intrinsicGas = this.gasCalculator.transactionIntrinsicGasCost(payload, contractCreation);
        this.updater = this.worldState.updater();
        this.coinbase = this.dynamicProperties.fundingAccountAddress();
    }

    protected long calculateGasUsedByTX(long txGasLimit, MessageFrame initialFrame) {
        long gasUsedByTransaction = txGasLimit - initialFrame.getRemainingGas();
        long selfDestructRefund = this.gasCalculator.getSelfDestructRefundAmount() * Math.min((long)initialFrame.getSelfDestructs().size(), gasUsedByTransaction / this.gasCalculator.getMaxRefundQuotient());
        gasUsedByTransaction = gasUsedByTransaction - selfDestructRefund - initialFrame.getGasRefund();
        int maxRefundPercent = this.dynamicProperties.maxGasRefundPercentage();
        gasUsedByTransaction = Math.max(gasUsedByTransaction, txGasLimit - txGasLimit * (long)maxRefundPercent / 100L);
        return gasUsedByTransaction;
    }

    protected long gasPriceTinyBarsGiven(Instant consensusTime, boolean isEthTxn) {
        return this.livePricesSource.currentGasPrice(consensusTime, isEthTxn ? HederaFunctionality.EthereumTransaction : this.getFunctionType());
    }

    protected abstract HederaFunctionality getFunctionType();

    protected abstract MessageFrame buildInitialFrame(MessageFrame.Builder var1, Address var2, Bytes var3, long var4);

    protected void process(MessageFrame frame, OperationTracer operationTracer) {
        AbstractMessageProcessor executor = this.getMessageProcessor(frame.getType());
        executor.process(frame, operationTracer);
    }

    private AbstractMessageProcessor getMessageProcessor(MessageFrame.Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case MessageFrame.Type.MESSAGE_CALL -> this.messageCallProcessor;
            case MessageFrame.Type.CONTRACT_CREATION -> this.contractCreationProcessor;
        };
    }

    @VisibleForTesting
    public void setGasCalculator(GasCalculator gasCalculator) {
        this.gasCalculator = gasCalculator;
    }
}

