/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.contracts.operations;

import com.hedera.node.app.service.evm.contracts.operations.CreateOperationExternalizer;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.account.MutableAccount;
import org.hyperledger.besu.evm.code.CodeFactory;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public abstract class AbstractEvmRecordingCreateOperation
extends AbstractOperation {
    protected static final int MAX_STACK_DEPTH = 1024;
    protected static final Operation.OperationResult INVALID_RESPONSE = new Operation.OperationResult(0L, ExceptionalHaltReason.INVALID_OPERATION);
    protected static final Operation.OperationResult UNDERFLOW_RESPONSE = new Operation.OperationResult(0L, ExceptionalHaltReason.INSUFFICIENT_STACK_ITEMS);
    private final CreateOperationExternalizer createOperationExternalizer;

    protected AbstractEvmRecordingCreateOperation(int opcode, String name, int stackItemsConsumed, int stackItemsProduced, GasCalculator gasCalculator, CreateOperationExternalizer createOperationExternalizer) {
        super(opcode, name, stackItemsConsumed, stackItemsProduced, gasCalculator);
        this.createOperationExternalizer = createOperationExternalizer;
    }

    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        if (!this.isEnabled()) {
            return INVALID_RESPONSE;
        }
        if (frame.stackSize() < this.getStackItemsConsumed()) {
            return UNDERFLOW_RESPONSE;
        }
        long cost = this.cost(frame);
        if (frame.isStatic()) {
            return AbstractEvmRecordingCreateOperation.haltWith(cost, ExceptionalHaltReason.ILLEGAL_STATE_CHANGE);
        }
        if (frame.getRemainingGas() < cost) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        Wei value = Wei.wrap((Bytes)frame.getStackItem(0));
        Address address = frame.getRecipientAddress();
        MutableAccount account = frame.getWorldUpdater().getAccount(address);
        frame.clearReturnData();
        if (value.compareTo((Bytes)account.getBalance()) > 0 || frame.getDepth() >= 1024) {
            this.fail(frame);
        } else {
            this.spawnChildMessage(frame);
        }
        return new Operation.OperationResult(cost, null);
    }

    public static Operation.OperationResult haltWith(long cost, ExceptionalHaltReason reason) {
        return new Operation.OperationResult(cost, reason);
    }

    protected abstract boolean isEnabled();

    protected abstract long cost(MessageFrame var1);

    protected abstract Address targetContractAddress(MessageFrame var1);

    protected void fail(MessageFrame frame) {
        long inputOffset = Words.clampedToLong((Bytes)frame.getStackItem(1));
        long inputSize = Words.clampedToLong((Bytes)frame.getStackItem(2));
        frame.readMutableMemory(inputOffset, inputSize);
        frame.popStackItems(this.getStackItemsConsumed());
        frame.pushStackItem((Bytes)UInt256.ZERO);
    }

    private void spawnChildMessage(MessageFrame frame) {
        long cost = this.cost(frame);
        frame.decrementRemainingGas(cost);
        Address address = frame.getRecipientAddress();
        MutableAccount account = frame.getWorldUpdater().getAccount(address);
        account.incrementNonce();
        Wei value = Wei.wrap((Bytes)frame.getStackItem(0));
        long inputOffset = Words.clampedToLong((Bytes)frame.getStackItem(1));
        long inputSize = Words.clampedToLong((Bytes)frame.getStackItem(2));
        Bytes inputData = frame.readMemory(inputOffset, inputSize);
        Address contractAddress = this.targetContractAddress(frame);
        if (this.createOperationExternalizer.shouldFailBasedOnLazyCreation(frame, contractAddress)) {
            this.fail(frame);
            return;
        }
        long childGasStipend = this.gasCalculator().gasAvailableForChildCreate(frame.getRemainingGas());
        frame.decrementRemainingGas(childGasStipend);
        MessageFrame.builder().parentMessageFrame(frame).type(MessageFrame.Type.CONTRACT_CREATION).worldUpdater(frame.getWorldUpdater().updater()).initialGas(childGasStipend).address(contractAddress).originator(frame.getOriginatorAddress()).contract(contractAddress).gasPrice(frame.getGasPrice()).inputData(Bytes.EMPTY).sender(frame.getRecipientAddress()).value(value).apparentValue(value).code(CodeFactory.createCode((Bytes)inputData, (int)0, (boolean)false)).blockValues(frame.getBlockValues()).completer(child -> this.complete(frame, (MessageFrame)child)).miningBeneficiary(frame.getMiningBeneficiary()).blockHashLookup(frame.getBlockHashLookup()).maxStackSize(frame.getMaxStackSize()).build();
        frame.incrementRemainingGas(cost);
        frame.setState(MessageFrame.State.CODE_SUSPENDED);
    }

    private void complete(MessageFrame frame, MessageFrame childFrame) {
        frame.setState(MessageFrame.State.CODE_EXECUTING);
        frame.incrementRemainingGas(childFrame.getRemainingGas());
        frame.addLogs(childFrame.getLogs());
        frame.addSelfDestructs(childFrame.getSelfDestructs());
        frame.incrementGasRefund(childFrame.getGasRefund());
        frame.popStackItems(this.getStackItemsConsumed());
        if (childFrame.getState() == MessageFrame.State.COMPLETED_SUCCESS) {
            frame.pushStackItem((Bytes)Words.fromAddress((Address)childFrame.getContractAddress()));
            this.createOperationExternalizer.externalize(frame, childFrame);
        } else {
            frame.setReturnData(childFrame.getOutputData());
            frame.pushStackItem((Bytes)UInt256.ZERO);
        }
        int currentPC = frame.getPC();
        frame.setPC(currentPC + 1);
    }
}

