/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.contracts.operations;

import com.hedera.node.app.service.evm.contracts.operations.AbstractEvmRecordingCreateOperation;
import com.hedera.node.app.service.evm.contracts.operations.CreateOperationExternalizer;
import com.hedera.node.app.service.evm.store.contracts.HederaEvmStackedWorldUpdater;
import javax.inject.Inject;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;

public class HederaEvmCreateOperation
extends AbstractEvmRecordingCreateOperation {
    @Inject
    public HederaEvmCreateOperation(GasCalculator gasCalculator, CreateOperationExternalizer createOperationExternalizer) {
        super(240, "\u0127CREATE", 3, 1, gasCalculator, createOperationExternalizer);
    }

    @Override
    public long cost(MessageFrame frame) {
        return this.gasCalculator().createOperationGasCost(frame);
    }

    @Override
    protected boolean isEnabled() {
        return true;
    }

    @Override
    protected Address targetContractAddress(MessageFrame frame) {
        Address sourceAddressOrAlias = frame.getRecipientAddress();
        long sourceNonce = frame.getWorldUpdater().getAccount(sourceAddressOrAlias).getNonce();
        HederaEvmStackedWorldUpdater updater = (HederaEvmStackedWorldUpdater)frame.getWorldUpdater();
        Address alias = Address.contractAddress((Address)sourceAddressOrAlias, (long)(sourceNonce - 1L));
        Address address = updater.newAliasedContractAddress(sourceAddressOrAlias, alias);
        frame.warmUpAddress(address);
        frame.warmUpAddress(alias);
        return alias;
    }
}

