/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.contracts.operations;

import com.hedera.node.app.service.evm.store.contracts.AbstractLedgerEvmWorldUpdater;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.OverflowException;
import org.hyperledger.besu.evm.internal.UnderflowException;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class HederaEvmSLoadOperation
extends AbstractOperation {
    protected final long warmCost;
    protected final long coldCost;
    protected final Operation.OperationResult warmSuccess;
    protected final Operation.OperationResult coldSuccess;

    public HederaEvmSLoadOperation(GasCalculator gasCalculator) {
        super(84, "SLOAD", 1, 1, gasCalculator);
        long baseCost = gasCalculator.getSloadOperationGasCost();
        this.warmCost = baseCost + gasCalculator.getWarmStorageReadCost();
        this.coldCost = baseCost + gasCalculator.getColdSloadCost();
        this.warmSuccess = new Operation.OperationResult(this.warmCost, null);
        this.coldSuccess = new Operation.OperationResult(this.coldCost, null);
    }

    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        try {
            long optionalCost;
            Address addressOrAlias = frame.getRecipientAddress();
            AbstractLedgerEvmWorldUpdater worldUpdater = (AbstractLedgerEvmWorldUpdater)frame.getWorldUpdater();
            Account account = worldUpdater.get(addressOrAlias);
            Address address = account.getAddress();
            UInt256 key = UInt256.fromBytes((Bytes)frame.popStackItem());
            boolean slotIsWarm = frame.warmUpStorage(address, (Bytes32)key);
            long l = optionalCost = slotIsWarm ? this.warmCost : this.coldCost;
            if (frame.getRemainingGas() < optionalCost) {
                return new Operation.OperationResult(optionalCost, ExceptionalHaltReason.INSUFFICIENT_GAS);
            }
            UInt256 storageValue = account.getStorageValue(UInt256.fromBytes((Bytes)key));
            this.intermediateCustomLogic(frame, address, (Bytes32)key, storageValue);
            frame.pushStackItem((Bytes)storageValue);
            return slotIsWarm ? this.warmSuccess : this.coldSuccess;
        }
        catch (UnderflowException ufe) {
            return new Operation.OperationResult(this.warmCost, ExceptionalHaltReason.INSUFFICIENT_STACK_ITEMS);
        }
        catch (OverflowException ofe) {
            return new Operation.OperationResult(this.warmCost, ExceptionalHaltReason.TOO_MANY_STACK_ITEMS);
        }
    }

    protected void intermediateCustomLogic(MessageFrame frame, Address address, Bytes32 key, UInt256 storageValue) {
    }
}

