/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.store.contracts.precompile.codec;

import java.util.Objects;
import org.hyperledger.besu.datatypes.Address;

public class FixedFee {
    private final long amount;
    private final Address denominatingTokenId;
    private final boolean useHbarsForPayment;
    private final boolean useCurrentTokenForPayment;
    private final Address feeCollector;

    public FixedFee(long amount, Address denominatingTokenId, boolean useHbarsForPayment, boolean useCurrentTokenForPayment, Address feeCollector) {
        this.amount = amount;
        this.denominatingTokenId = denominatingTokenId;
        this.useHbarsForPayment = useHbarsForPayment;
        this.useCurrentTokenForPayment = useCurrentTokenForPayment;
        this.feeCollector = feeCollector;
    }

    public long getAmount() {
        return this.amount;
    }

    public Address getDenominatingTokenId() {
        return this.denominatingTokenId != null ? this.denominatingTokenId : Address.ZERO;
    }

    public Address getFeeCollector() {
        return this.feeCollector != null ? this.feeCollector : Address.ZERO;
    }

    public boolean isUseHbarsForPayment() {
        return this.useHbarsForPayment;
    }

    public boolean isUseCurrentTokenForPayment() {
        return this.useCurrentTokenForPayment;
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.denominatingTokenId, this.useHbarsForPayment, this.useCurrentTokenForPayment, this.feeCollector);
    }

    public boolean equals(Object o) {
        if (o == null || FixedFee.class != o.getClass()) {
            return false;
        }
        FixedFee other = (FixedFee)o;
        return this.amount == other.amount && this.useHbarsForPayment == other.useHbarsForPayment && this.useCurrentTokenForPayment == other.useCurrentTokenForPayment;
    }

    public String toString() {
        return "FixedFee{amount=" + this.amount + ", denominatingTokenId=" + String.valueOf(this.denominatingTokenId) + ", useHbarsForPayment=" + this.useHbarsForPayment + ", useCurrentTokenForPayment=" + this.useCurrentTokenForPayment + ", feeCollector=" + String.valueOf(this.feeCollector) + "}";
    }
}

