/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.store.contracts.precompile.proxy;

import com.hedera.node.app.service.evm.exceptions.InvalidTransactionException;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.BalanceOfWrapper;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.EvmEncodingFacade;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.GetApprovedWrapper;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.IsApproveForAllWrapper;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.OwnerOfAndTokenURIWrapper;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.TokenAllowanceWrapper;
import com.hedera.node.app.service.evm.store.contracts.precompile.impl.EvmAllowancePrecompile;
import com.hedera.node.app.service.evm.store.contracts.precompile.impl.EvmBalanceOfPrecompile;
import com.hedera.node.app.service.evm.store.contracts.precompile.impl.EvmGetApprovedPrecompile;
import com.hedera.node.app.service.evm.store.contracts.precompile.impl.EvmIsApprovedForAllPrecompile;
import com.hedera.node.app.service.evm.store.contracts.precompile.impl.EvmOwnerOfPrecompile;
import com.hedera.node.app.service.evm.store.contracts.precompile.impl.EvmTokenURIPrecompile;
import com.hedera.node.app.service.evm.store.contracts.precompile.proxy.RedirectTarget;
import com.hedera.node.app.service.evm.store.contracts.precompile.proxy.ViewGasCalculator;
import com.hedera.node.app.service.evm.store.contracts.utils.DescriptorUtils;
import com.hedera.node.app.service.evm.store.tokens.TokenAccessor;
import com.hedera.node.app.service.evm.store.tokens.TokenType;
import com.hedera.node.app.service.evm.utils.ValidationUtils;
import com.hederahashgraph.api.proto.java.ResponseCodeEnum;
import com.hederahashgraph.api.proto.java.Timestamp;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class RedirectViewExecutor {
    private final Bytes input;
    private final MessageFrame frame;
    private final EvmEncodingFacade evmEncoder;
    private final ViewGasCalculator gasCalculator;
    private final TokenAccessor tokenAccessor;

    public RedirectViewExecutor(Bytes input, MessageFrame frame, EvmEncodingFacade evmEncoder, ViewGasCalculator gasCalculator, TokenAccessor tokenAccessor) {
        this.input = input;
        this.frame = frame;
        this.evmEncoder = evmEncoder;
        this.gasCalculator = gasCalculator;
        this.tokenAccessor = tokenAccessor;
    }

    public static Timestamp asSecondsTimestamp(long now) {
        return Timestamp.newBuilder().setSeconds(now).build();
    }

    public Pair<Long, Bytes> computeCosted() {
        RedirectTarget target = DescriptorUtils.getRedirectTarget(this.input);
        Timestamp now = RedirectViewExecutor.asSecondsTimestamp(this.frame.getBlockValues().getTimestamp());
        long costInGas = this.gasCalculator.compute(now, 100L);
        int selector = target.descriptor();
        boolean isFungibleToken = TokenType.FUNGIBLE_COMMON.equals((Object)this.tokenAccessor.typeOf(target.token()));
        try {
            Bytes answer = this.answerGiven(selector, target.token(), isFungibleToken);
            return Pair.of((Object)costInGas, (Object)answer);
        }
        catch (InvalidTransactionException e) {
            if (e.isReverting()) {
                this.frame.setRevertReason(e.getRevertReason());
                this.frame.setState(MessageFrame.State.REVERT);
            }
            return Pair.of((Object)costInGas, null);
        }
    }

    private Bytes answerGiven(int selector, Address token, boolean isFungibleToken) {
        if (selector == 117300739) {
            String name = this.tokenAccessor.nameOf(token);
            return this.evmEncoder.encodeName(name);
        }
        if (selector == -1780966591) {
            String symbol = this.tokenAccessor.symbolOf(token);
            return this.evmEncoder.encodeSymbol(symbol);
        }
        if (selector == -580719298) {
            TokenAllowanceWrapper<byte[], byte[], byte[]> wrapper = EvmAllowancePrecompile.decodeTokenAllowance(this.input);
            long allowance = this.tokenAccessor.staticAllowanceOf(DescriptorUtils.addressFromBytes(wrapper.owner()), DescriptorUtils.addressFromBytes(wrapper.spender()), DescriptorUtils.addressFromBytes(wrapper.token()));
            return this.evmEncoder.encodeAllowance(allowance);
        }
        if (selector == 135795452) {
            GetApprovedWrapper<byte[]> wrapper = EvmGetApprovedPrecompile.decodeGetApproved(this.input);
            Address spender = this.tokenAccessor.staticApprovedSpenderOf(DescriptorUtils.addressFromBytes(wrapper.token()), wrapper.serialNo());
            Address priorityAddress = this.tokenAccessor.canonicalAddress(spender);
            return this.evmEncoder.encodeGetApproved(priorityAddress);
        }
        if (selector == -377099835) {
            IsApproveForAllWrapper<byte[], byte[], byte[]> wrapper = EvmIsApprovedForAllPrecompile.decodeIsApprovedForAll(this.input);
            boolean isOperator = this.tokenAccessor.staticIsOperator(DescriptorUtils.addressFromBytes(wrapper.owner()), DescriptorUtils.addressFromBytes(wrapper.operator()), DescriptorUtils.addressFromBytes(wrapper.token()));
            return this.evmEncoder.encodeIsApprovedForAll(isOperator);
        }
        if (selector == 826074471) {
            ValidationUtils.validateTrue(isFungibleToken, ResponseCodeEnum.INVALID_TOKEN_ID);
            int decimals = this.tokenAccessor.decimalsOf(token);
            return this.evmEncoder.encodeDecimals(decimals);
        }
        if (selector == 404098525) {
            long totalSupply = this.tokenAccessor.totalSupplyOf(token);
            return this.evmEncoder.encodeTotalSupply(totalSupply);
        }
        if (selector == 1889567281) {
            BalanceOfWrapper<byte[]> wrapper = EvmBalanceOfPrecompile.decodeBalanceOf(this.input.slice(24));
            long balance = this.tokenAccessor.balanceOf(DescriptorUtils.addressFromBytes(wrapper.account()), token);
            return this.evmEncoder.encodeBalance(balance);
        }
        if (selector == 1666326814) {
            ValidationUtils.validateFalse(isFungibleToken, ResponseCodeEnum.INVALID_TOKEN_ID);
            OwnerOfAndTokenURIWrapper wrapper = EvmOwnerOfPrecompile.decodeOwnerOf(this.input.slice(24));
            Address owner = this.tokenAccessor.ownerOf(token, wrapper.serialNo());
            Address priorityAddress = this.tokenAccessor.canonicalAddress(owner);
            return this.evmEncoder.encodeOwner(priorityAddress);
        }
        if (selector == -931440931) {
            ValidationUtils.validateFalse(isFungibleToken, ResponseCodeEnum.INVALID_TOKEN_ID);
            OwnerOfAndTokenURIWrapper wrapper = EvmTokenURIPrecompile.decodeTokenUriNFT(this.input.slice(24));
            String metadata = this.tokenAccessor.metadataOf(token, wrapper.serialNo());
            return this.evmEncoder.encodeTokenUri(metadata);
        }
        throw new InvalidTransactionException(ResponseCodeEnum.NOT_SUPPORTED);
    }
}

