/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.contracts.execution;

import com.hedera.node.app.service.evm.contracts.operations.HederaExceptionalHaltReason;
import com.hedera.node.app.service.evm.store.contracts.AbstractLedgerEvmWorldUpdater;
import com.hedera.node.app.service.evm.store.contracts.precompile.EvmHTSPrecompiledContract;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt256Value;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.operation.Operation;
import org.hyperledger.besu.evm.precompile.PrecompileContractRegistry;
import org.hyperledger.besu.evm.precompile.PrecompiledContract;
import org.hyperledger.besu.evm.processor.MessageCallProcessor;
import org.hyperledger.besu.evm.tracing.OperationTracer;

public class HederaEvmMessageCallProcessorV038
extends MessageCallProcessor {
    private static final Optional<ExceptionalHaltReason> ILLEGAL_STATE_CHANGE = Optional.of(ExceptionalHaltReason.ILLEGAL_STATE_CHANGE);
    protected final Map<Address, PrecompiledContract> hederaPrecompiles = new HashMap<Address, PrecompiledContract>();
    protected long gasRequirement;
    protected Bytes output;
    private final Predicate<Address> evmNativePrecompileDetector;
    private final Predicate<Address> systemAccountDetector;

    public HederaEvmMessageCallProcessorV038(EVM evm, PrecompileContractRegistry precompiles, Map<String, PrecompiledContract> hederaPrecompileList, Predicate<Address> systemAccountDetector) {
        super(evm, precompiles);
        hederaPrecompileList.forEach((k, v) -> this.hederaPrecompiles.put(Address.fromHexString((String)k), (PrecompiledContract)v));
        this.evmNativePrecompileDetector = addr -> precompiles.get(addr) != null;
        this.systemAccountDetector = systemAccountDetector;
    }

    public void start(MessageFrame frame, OperationTracer operationTracer) {
        PrecompiledContract hederaPrecompile = this.hederaPrecompiles.get(frame.getContractAddress());
        if (hederaPrecompile != null) {
            this.executeHederaPrecompile(hederaPrecompile, frame, operationTracer);
        } else {
            boolean frameHasValue = frame.getValue().greaterThan((UInt256Value)Wei.ZERO);
            if (this.systemAccountDetector.test(frame.getContractAddress())) {
                if (!this.evmNativePrecompileDetector.test(frame.getContractAddress())) {
                    frame.setExceptionalHaltReason(Optional.of(ExceptionalHaltReason.PRECOMPILE_ERROR));
                    frame.setState(MessageFrame.State.EXCEPTIONAL_HALT);
                    operationTracer.tracePostExecution(frame, new Operation.OperationResult(frame.getRemainingGas(), ExceptionalHaltReason.PRECOMPILE_ERROR));
                    return;
                }
                if (frameHasValue) {
                    frame.setExceptionalHaltReason(Optional.of(HederaExceptionalHaltReason.INVALID_FEE_SUBMITTED));
                    frame.setState(MessageFrame.State.EXCEPTIONAL_HALT);
                    operationTracer.tracePostExecution(frame, new Operation.OperationResult(frame.getRemainingGas(), HederaExceptionalHaltReason.INVALID_FEE_SUBMITTED));
                    return;
                }
            } else if (frameHasValue) {
                AbstractLedgerEvmWorldUpdater updater = (AbstractLedgerEvmWorldUpdater)frame.getWorldUpdater();
                if (updater.isTokenAddress(frame.getRecipientAddress())) {
                    frame.setExceptionalHaltReason(ILLEGAL_STATE_CHANGE);
                    frame.setState(MessageFrame.State.EXCEPTIONAL_HALT);
                    operationTracer.tracePostExecution(frame, new Operation.OperationResult(frame.getRemainingGas(), ExceptionalHaltReason.ILLEGAL_STATE_CHANGE));
                    return;
                }
                if (updater.get(frame.getRecipientAddress()) == null) {
                    this.executeLazyCreate(frame, operationTracer);
                    if (frame.getState() == MessageFrame.State.EXCEPTIONAL_HALT) {
                        return;
                    }
                }
            }
            super.start(frame, operationTracer);
        }
    }

    protected void executeHederaPrecompile(PrecompiledContract contract, MessageFrame frame, OperationTracer operationTracer) {
        if (contract instanceof EvmHTSPrecompiledContract) {
            EvmHTSPrecompiledContract htsPrecompile = (EvmHTSPrecompiledContract)contract;
            AbstractLedgerEvmWorldUpdater updater = (AbstractLedgerEvmWorldUpdater)frame.getWorldUpdater();
            Pair<Long, Bytes> costedResult = htsPrecompile.computeCosted(frame.getInputData(), frame, (now, minimumTinybarCost) -> minimumTinybarCost, updater.tokenAccessor());
            this.output = (Bytes)costedResult.getValue();
            this.gasRequirement = (Long)costedResult.getKey();
        }
        if (!"HTS".equals(contract.getName()) && !"EvmHTS".equals(contract.getName())) {
            this.output = contract.computePrecompile(frame.getInputData(), frame).getOutput();
            this.gasRequirement = contract.gasRequirement(frame.getInputData());
        }
        operationTracer.tracePrecompileCall(frame, this.gasRequirement, this.output);
        if (frame.getState() == MessageFrame.State.REVERT) {
            return;
        }
        if (frame.getRemainingGas() < this.gasRequirement) {
            frame.decrementRemainingGas(frame.getRemainingGas());
            frame.setExceptionalHaltReason(Optional.of(ExceptionalHaltReason.INSUFFICIENT_GAS));
            frame.setState(MessageFrame.State.EXCEPTIONAL_HALT);
        } else if (this.output != null) {
            frame.decrementRemainingGas(this.gasRequirement);
            frame.setOutputData(this.output);
            frame.setState(MessageFrame.State.COMPLETED_SUCCESS);
        } else {
            frame.setState(MessageFrame.State.EXCEPTIONAL_HALT);
        }
    }

    protected void executeLazyCreate(MessageFrame frame, OperationTracer operationTracer) {
    }
}

