/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.contracts.operations;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.node.app.service.evm.contracts.execution.EvmProperties;
import com.hedera.node.app.service.evm.contracts.operations.HederaEvmOperationsUtilV038;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.BalanceOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class HederaBalanceOperationV038
extends BalanceOperation {
    private BiPredicate<Address, MessageFrame> addressValidator;
    private final Predicate<Address> systemAccountDetector;
    private final EvmProperties evmProperties;

    public HederaBalanceOperationV038(GasCalculator gasCalculator, BiPredicate<Address, MessageFrame> addressValidator, Predicate<Address> systemAccountDetector, EvmProperties evmProperties) {
        super(gasCalculator);
        this.addressValidator = addressValidator;
        this.systemAccountDetector = systemAccountDetector;
        this.evmProperties = evmProperties;
    }

    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        Supplier<Operation.OperationResult> systemAccountExecutionSupplier = () -> {
            frame.popStackItems(1);
            frame.pushStackItem((Bytes)UInt256.ZERO);
            return new Operation.OperationResult(this.cost(true), null);
        };
        return HederaEvmOperationsUtilV038.addressCheckExecution(frame, () -> frame.getStackItem(0), () -> this.cost(true), () -> super.execute(frame, evm), this.addressValidator, this.systemAccountDetector, systemAccountExecutionSupplier, this.evmProperties);
    }

    @VisibleForTesting
    public BiPredicate<Address, MessageFrame> getAddressValidator() {
        return this.addressValidator;
    }

    @VisibleForTesting
    public void setAddressValidator(BiPredicate<Address, MessageFrame> addressValidator) {
        this.addressValidator = addressValidator;
    }
}

