/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.contracts.operations;

import com.hedera.node.app.service.evm.contracts.execution.EvmProperties;
import com.hedera.node.app.service.evm.contracts.operations.HederaEvmOperationsUtilV038;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.DelegateCallOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class HederaDelegateCallOperationV038
extends DelegateCallOperation {
    private final BiPredicate<Address, MessageFrame> addressValidator;
    private final Predicate<Address> systemAccountDetector;
    private final EvmProperties evmProperties;

    public HederaDelegateCallOperationV038(GasCalculator gasCalculator, BiPredicate<Address, MessageFrame> addressValidator, Predicate<Address> systemAccountDetector, EvmProperties evmProperties) {
        super(gasCalculator);
        this.addressValidator = addressValidator;
        this.systemAccountDetector = systemAccountDetector;
        this.evmProperties = evmProperties;
    }

    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        return HederaEvmOperationsUtilV038.addressCheckExecution(frame, () -> this.to(frame), () -> this.cost(frame), () -> super.execute(frame, evm), this.addressValidator, this.systemAccountDetector, () -> super.execute(frame, evm), this.evmProperties);
    }
}

