/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.contracts.operations;

import com.hedera.node.app.service.evm.contracts.operations.HederaExceptionalHaltReason;
import java.util.function.BiPredicate;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.internal.UnderflowException;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.Operation;

public interface HederaEvmOperationsUtil {
    public static Operation.OperationResult addressCheckExecution(MessageFrame frame, Supplier<Bytes> supplierAddressBytes, LongSupplier supplierHaltGasCost, Supplier<Operation.OperationResult> supplierExecution, BiPredicate<Address, MessageFrame> addressValidator) {
        try {
            Address address = Words.toAddress((Bytes)supplierAddressBytes.get());
            if (Boolean.FALSE.equals(addressValidator.test(address, frame))) {
                return new Operation.OperationResult(supplierHaltGasCost.getAsLong(), HederaExceptionalHaltReason.INVALID_SOLIDITY_ADDRESS);
            }
            return supplierExecution.get();
        }
        catch (UnderflowException ufe) {
            return new Operation.OperationResult(supplierHaltGasCost.getAsLong(), ExceptionalHaltReason.INSUFFICIENT_STACK_ITEMS);
        }
    }
}

