/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.contracts.operations;

import com.hedera.node.app.service.evm.contracts.execution.EvmProperties;
import com.hedera.node.app.service.evm.contracts.operations.HederaExceptionalHaltReason;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.function.BiPredicate;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.internal.OverflowException;
import org.hyperledger.besu.evm.internal.UnderflowException;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.Operation;

public interface HederaEvmOperationsUtilV038 {
    public static final String EVM_VERSION_0_46 = "v0.46";

    public static Operation.OperationResult addressCheckExecution(@NonNull MessageFrame frame, @NonNull Supplier<Bytes> supplierAddressBytes, @NonNull LongSupplier supplierHaltGasCost, @NonNull Supplier<Operation.OperationResult> supplierExecution, @NonNull BiPredicate<Address, MessageFrame> addressValidator, @NonNull Predicate<Address> systemAccountDetector, @NonNull Supplier<Operation.OperationResult> systemAccountExecutionSupplier, @NonNull EvmProperties evmProperties) {
        try {
            Address address = Words.toAddress((Bytes)supplierAddressBytes.get());
            if (systemAccountDetector.test(address)) {
                return systemAccountExecutionSupplier.get();
            }
            if (!evmProperties.callsToNonExistingEntitiesEnabled(frame.getContractAddress()) && Boolean.FALSE.equals(addressValidator.test(address, frame))) {
                return new Operation.OperationResult(supplierHaltGasCost.getAsLong(), HederaExceptionalHaltReason.INVALID_SOLIDITY_ADDRESS);
            }
            return supplierExecution.get();
        }
        catch (UnderflowException ufe) {
            return new Operation.OperationResult(supplierHaltGasCost.getAsLong(), ExceptionalHaltReason.INSUFFICIENT_STACK_ITEMS);
        }
        catch (OverflowException ofe) {
            return new Operation.OperationResult(supplierHaltGasCost.getAsLong(), ExceptionalHaltReason.TOO_MANY_STACK_ITEMS);
        }
    }
}

