/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.contracts.operations;

import com.hedera.node.app.service.evm.contracts.execution.EvmProperties;
import com.hedera.node.app.service.evm.contracts.operations.HederaEvmOperationsUtilV038;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.ExtCodeCopyOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class HederaExtCodeCopyOperationV038
extends ExtCodeCopyOperation {
    private final BiPredicate<Address, MessageFrame> addressValidator;
    private final Predicate<Address> systemAccountDetector;
    private final EvmProperties evmProperties;

    public HederaExtCodeCopyOperationV038(GasCalculator gasCalculator, BiPredicate<Address, MessageFrame> addressValidator, Predicate<Address> systemAccountDetector, EvmProperties evmProperties) {
        super(gasCalculator);
        this.addressValidator = addressValidator;
        this.systemAccountDetector = systemAccountDetector;
        this.evmProperties = evmProperties;
    }

    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        long memOffset = Words.clampedToLong((Bytes)frame.getStackItem(1));
        long numBytes = Words.clampedToLong((Bytes)frame.getStackItem(3));
        Supplier<Operation.OperationResult> systemAccountExecutionSupplier = () -> {
            long sourceOffset = Words.clampedToLong((Bytes)frame.getStackItem(2));
            frame.writeMemory(memOffset, sourceOffset, numBytes, Bytes.EMPTY);
            frame.popStackItems(4);
            return new Operation.OperationResult(this.cost(frame, memOffset, numBytes, true), null);
        };
        return HederaEvmOperationsUtilV038.addressCheckExecution(frame, () -> frame.getStackItem(0), () -> this.cost(frame, memOffset, numBytes, true), () -> super.execute(frame, evm), this.addressValidator, this.systemAccountDetector, systemAccountExecutionSupplier, this.evmProperties);
    }
}

