/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.store.contracts;

import com.hedera.node.app.service.evm.accounts.AccountAccessor;
import com.hedera.node.app.service.evm.store.contracts.HederaEvmEntityAccess;
import com.hedera.node.app.service.evm.store.models.UpdateTrackingAccount;
import com.hedera.node.app.service.evm.store.tokens.TokenAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.account.MutableAccount;
import org.hyperledger.besu.evm.worldstate.WorldUpdater;
import org.hyperledger.besu.evm.worldstate.WorldView;

public abstract class AbstractLedgerEvmWorldUpdater<W extends WorldView, A extends Account>
implements WorldUpdater {
    protected final W world;
    protected final AccountAccessor accountAccessor;
    protected Map<Address, UpdateTrackingAccount<A>> updatedAccounts = new HashMap<Address, UpdateTrackingAccount<A>>();
    private HederaEvmEntityAccess hederaEvmEntityAccess;
    private TokenAccessor tokenAccessor;
    protected Set<Address> deletedAccounts = new HashSet<Address>();

    protected AbstractLedgerEvmWorldUpdater(W world, AccountAccessor accountAccessor) {
        this.world = world;
        this.accountAccessor = accountAccessor;
    }

    protected AbstractLedgerEvmWorldUpdater(W world, AccountAccessor accountAccessor, TokenAccessor tokenAccessor, HederaEvmEntityAccess hederaEvmEntityAccess) {
        this(world, accountAccessor);
        this.hederaEvmEntityAccess = hederaEvmEntityAccess;
        this.tokenAccessor = tokenAccessor;
    }

    public abstract A getForMutation(Address var1);

    protected W wrappedWorldView() {
        return this.world;
    }

    public MutableAccount createAccount(Address address, long nonce, Wei balance) {
        return null;
    }

    public MutableAccount getOrCreate(Address address) {
        return null;
    }

    public void deleteAccount(Address address) {
    }

    public Collection<? extends Account> getTouchedAccounts() {
        return new ArrayList<UpdateTrackingAccount<A>>(this.updatedAccounts.values());
    }

    public Collection<Address> getDeletedAccountAddresses() {
        return new ArrayList<Address>(this.deletedAccounts);
    }

    public void revert() {
    }

    public void commit() {
    }

    public Optional<WorldUpdater> parentUpdater() {
        return Optional.empty();
    }

    public WorldUpdater updater() {
        return this;
    }

    public boolean isTokenAddress(Address address) {
        return this.accountAccessor.isTokenAddress(address);
    }

    public Account get(Address address) {
        if (!address.equals((Object)this.accountAccessor.canonicalAddress(address))) {
            return null;
        }
        UpdateTrackingAccount<A> extantMutable = this.updatedAccounts.get(address);
        if (extantMutable != null) {
            return extantMutable;
        }
        return this.world.get(address);
    }

    public MutableAccount getAccount(Address address) {
        UpdateTrackingAccount<A> extantMutable = this.updatedAccounts.get(address);
        if (extantMutable != null) {
            return extantMutable;
        }
        A origin = this.getForMutation(address);
        if (origin == null) {
            return null;
        }
        UpdateTrackingAccount<A> trackedAccount = this.track(new UpdateTrackingAccount<A>(origin, null));
        trackedAccount.setEvmEntityAccess(this.hederaEvmEntityAccess);
        return trackedAccount;
    }

    public Map<Address, UpdateTrackingAccount<A>> getUpdatedAccounts() {
        return this.updatedAccounts;
    }

    public UpdateTrackingAccount<A> track(UpdateTrackingAccount<A> account) {
        Address address = account.getAddress();
        this.updatedAccounts.put(address, account);
        this.deletedAccounts.remove(address);
        return account;
    }

    public TokenAccessor tokenAccessor() {
        return this.tokenAccessor;
    }
}

