/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.store.contracts.precompile.codec;

import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TupleType;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.CustomFee;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.EvmKey;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.EvmNftInfo;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.EvmTokenInfo;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.FixedFee;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.FractionalFee;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.RoyaltyFee;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.TokenExpiryInfo;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.TokenKeyType;
import com.hedera.node.app.service.evm.store.contracts.utils.EvmParsingConstants;
import com.hederahashgraph.api.proto.java.ResponseCodeEnum;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;

@Singleton
public class EvmEncodingFacade {
    @Inject
    public EvmEncodingFacade() {
    }

    public Bytes encodeDecimals(int decimals) {
        return this.functionResultBuilder().forFunction(EvmParsingConstants.FunctionType.ERC_DECIMALS).withDecimals(decimals).build();
    }

    public Bytes encodeGetTokenType(int tokenType) {
        return this.encodeGetTokenType(ResponseCodeEnum.SUCCESS, tokenType);
    }

    public Bytes encodeGetTokenType(ResponseCodeEnum status, int tokenType) {
        return this.functionResultBuilder().forFunction(EvmParsingConstants.FunctionType.HAPI_GET_TOKEN_TYPE).withStatus(status.getNumber()).withGetTokenType(tokenType).build();
    }

    public Bytes encodeAllowance(long allowance) {
        return this.functionResultBuilder().forFunction(EvmParsingConstants.FunctionType.ERC_ALLOWANCE).withAllowance(allowance).build();
    }

    public Bytes encodeTotalSupply(long totalSupply) {
        return this.functionResultBuilder().forFunction(EvmParsingConstants.FunctionType.ERC_TOTAL_SUPPLY).withTotalSupply(totalSupply).build();
    }

    public Bytes encodeBalance(long balance) {
        return this.functionResultBuilder().forFunction(EvmParsingConstants.FunctionType.ERC_BALANCE).withBalance(balance).build();
    }

    public Bytes encodeIsApprovedForAll(boolean isApprovedForAllStatus) {
        return this.functionResultBuilder().forFunction(EvmParsingConstants.FunctionType.ERC_IS_APPROVED_FOR_ALL).withIsApprovedForAllStatus(isApprovedForAllStatus).build();
    }

    public Bytes encodeIsFrozen(boolean isFrozen) {
        return this.encodeIsFrozen(ResponseCodeEnum.SUCCESS, isFrozen);
    }

    public Bytes encodeIsFrozen(ResponseCodeEnum status, boolean isFrozen) {
        return this.functionResultBuilder().forFunction(EvmParsingConstants.FunctionType.HAPI_IS_FROZEN).withStatus(status.getNumber()).withIsFrozen(isFrozen).build();
    }

    public Bytes encodeGetTokenDefaultFreezeStatus(boolean defaultFreezeStatus) {
        return this.encodeGetTokenDefaultFreezeStatus(ResponseCodeEnum.SUCCESS, defaultFreezeStatus);
    }

    public Bytes encodeGetTokenDefaultFreezeStatus(ResponseCodeEnum status, boolean defaultFreezeStatus) {
        return this.functionResultBuilder().forFunction(EvmParsingConstants.FunctionType.GET_TOKEN_DEFAULT_FREEZE_STATUS).withStatus(status.getNumber()).withGetTokenDefaultFreezeStatus(defaultFreezeStatus).build();
    }

    public Bytes encodeGetTokenDefaultKycStatus(boolean defaultKycStatus) {
        return this.encodeGetTokenDefaultKycStatus(ResponseCodeEnum.SUCCESS, defaultKycStatus);
    }

    public Bytes encodeGetTokenDefaultKycStatus(ResponseCodeEnum status, boolean defaultKycStatus) {
        return this.functionResultBuilder().forFunction(EvmParsingConstants.FunctionType.GET_TOKEN_DEFAULT_KYC_STATUS).withStatus(status.getNumber()).withGetTokenDefaultKycStatus(defaultKycStatus).build();
    }

    public Bytes encodeIsKyc(boolean isKyc) {
        return this.encodeIsKyc(ResponseCodeEnum.SUCCESS, isKyc);
    }

    public Bytes encodeIsKyc(ResponseCodeEnum status, boolean isKyc) {
        return this.functionResultBuilder().forFunction(EvmParsingConstants.FunctionType.HAPI_IS_KYC).withStatus(status.getNumber()).withIsKyc(isKyc).build();
    }

    public Bytes encodeIsToken(boolean isToken) {
        return this.encodeIsToken(ResponseCodeEnum.SUCCESS, isToken);
    }

    public Bytes encodeIsToken(ResponseCodeEnum status, boolean isToken) {
        return this.functionResultBuilder().forFunction(EvmParsingConstants.FunctionType.HAPI_IS_TOKEN).withStatus(status.getNumber()).withIsToken(isToken).build();
    }

    public Bytes encodeName(String name) {
        return this.functionResultBuilder().forFunction(EvmParsingConstants.FunctionType.ERC_NAME).withName(name).build();
    }

    public Bytes encodeSymbol(String symbol) {
        return this.functionResultBuilder().forFunction(EvmParsingConstants.FunctionType.ERC_SYMBOL).withSymbol(symbol).build();
    }

    public Bytes encodeTokenUri(String tokenUri) {
        return this.functionResultBuilder().forFunction(EvmParsingConstants.FunctionType.ERC_TOKEN_URI).withTokenUri(tokenUri).build();
    }

    public Bytes encodeOwner(Address address) {
        return this.functionResultBuilder().forFunction(EvmParsingConstants.FunctionType.ERC_OWNER).withOwner(address).build();
    }

    public Bytes encodeGetApproved(Address approved) {
        return this.functionResultBuilder().forFunction(EvmParsingConstants.FunctionType.ERC_GET_APPROVED).withApproved(approved).build();
    }

    public Bytes encodeGetTokenInfo(EvmTokenInfo tokenInfo) {
        return this.encodeGetTokenInfo(ResponseCodeEnum.SUCCESS, tokenInfo);
    }

    public Bytes encodeGetTokenInfo(ResponseCodeEnum status, EvmTokenInfo tokenInfo) {
        return this.functionResultBuilder().forFunction(EvmParsingConstants.FunctionType.HAPI_GET_TOKEN_INFO).withStatus(status.getNumber()).withTokenInfo(tokenInfo).build();
    }

    public Bytes encodeGetFungibleTokenInfo(EvmTokenInfo tokenInfo) {
        return this.encodeGetFungibleTokenInfo(ResponseCodeEnum.SUCCESS, tokenInfo);
    }

    public Bytes encodeGetFungibleTokenInfo(ResponseCodeEnum status, EvmTokenInfo tokenInfo) {
        return this.functionResultBuilder().forFunction(EvmParsingConstants.FunctionType.HAPI_GET_FUNGIBLE_TOKEN_INFO).withStatus(status.getNumber()).withTokenInfo(tokenInfo).build();
    }

    public Bytes encodeTokenGetCustomFees(List<CustomFee> customFees) {
        return this.encodeTokenGetCustomFees(ResponseCodeEnum.SUCCESS, customFees);
    }

    public Bytes encodeTokenGetCustomFees(ResponseCodeEnum status, List<CustomFee> customFees) {
        return this.functionResultBuilder().forFunction(EvmParsingConstants.FunctionType.HAPI_GET_TOKEN_CUSTOM_FEES).withStatus(status.getNumber()).withCustomFees(customFees).build();
    }

    public Bytes encodeGetNonFungibleTokenInfo(EvmTokenInfo tokenInfo, EvmNftInfo nonFungibleTokenInfo) {
        return this.encodeGetNonFungibleTokenInfo(ResponseCodeEnum.SUCCESS, tokenInfo, nonFungibleTokenInfo);
    }

    public Bytes encodeGetNonFungibleTokenInfo(ResponseCodeEnum status, EvmTokenInfo tokenInfo, EvmNftInfo nonFungibleTokenInfo) {
        return this.functionResultBuilder().forFunction(EvmParsingConstants.FunctionType.HAPI_GET_NON_FUNGIBLE_TOKEN_INFO).withStatus(status.getNumber()).withTokenInfo(tokenInfo).withNftTokenInfo(nonFungibleTokenInfo).build();
    }

    public Bytes encodeGetTokenExpiryInfo(TokenExpiryInfo tokenExpiryWrapper) {
        return this.encodeGetTokenExpiryInfo(ResponseCodeEnum.SUCCESS, tokenExpiryWrapper);
    }

    public Bytes encodeGetTokenExpiryInfo(ResponseCodeEnum status, TokenExpiryInfo tokenExpiryWrapper) {
        return this.functionResultBuilder().forFunction(EvmParsingConstants.FunctionType.HAPI_GET_TOKEN_EXPIRY_INFO).withStatus(status.getNumber()).withExpiry(tokenExpiryWrapper).build();
    }

    public Bytes encodeGetTokenKey(EvmKey keyValue) {
        return this.encodeGetTokenKey(ResponseCodeEnum.SUCCESS, keyValue);
    }

    public Bytes encodeGetTokenKey(ResponseCodeEnum status, EvmKey keyValue) {
        return this.functionResultBuilder().forFunction(EvmParsingConstants.FunctionType.HAPI_GET_TOKEN_KEY).withStatus(status.getNumber()).withKey(keyValue).build();
    }

    private FunctionResultBuilder functionResultBuilder() {
        return new FunctionResultBuilder();
    }

    static com.esaulpaugh.headlong.abi.Address convertBesuAddressToHeadlongAddress(@NonNull Address address) {
        return com.esaulpaugh.headlong.abi.Address.wrap((String)com.esaulpaugh.headlong.abi.Address.toChecksumAddress((BigInteger)address.toUnsignedBigInteger()));
    }

    private static class FunctionResultBuilder {
        private EvmParsingConstants.FunctionType functionType;
        private TupleType tupleType;
        private int status;
        private int decimals;
        private int tokenType;
        private long allowance;
        private long totalSupply;
        private long balance;
        private boolean isApprovedForAllStatus;
        private boolean isFrozen;
        private boolean tokenDefaultFreezeStatus;
        private boolean tokenDefaultKycStatus;
        private boolean isKyc;
        private boolean isToken;
        private String name;
        private String symbol;
        private String metadata;
        private Address owner;
        private Address approved;
        private EvmTokenInfo tokenInfo;
        private List<CustomFee> customFees;
        private EvmNftInfo nonFungibleTokenInfo;
        private Tuple tokenExpiryInfo;
        private Tuple keyValue;

        private FunctionResultBuilder() {
        }

        private FunctionResultBuilder forFunction(EvmParsingConstants.FunctionType functionType) {
            this.tupleType = switch (functionType) {
                case EvmParsingConstants.FunctionType.ERC_DECIMALS -> EvmParsingConstants.DECIMALS_TYPE;
                case EvmParsingConstants.FunctionType.HAPI_GET_TOKEN_TYPE -> EvmParsingConstants.intPairTuple;
                case EvmParsingConstants.FunctionType.ERC_ALLOWANCE, EvmParsingConstants.FunctionType.ERC_TOTAL_SUPPLY, EvmParsingConstants.FunctionType.ERC_BALANCE -> EvmParsingConstants.BIG_INTEGER_TUPLE;
                case EvmParsingConstants.FunctionType.ERC_IS_APPROVED_FOR_ALL -> EvmParsingConstants.BOOLEAN_TUPLE;
                case EvmParsingConstants.FunctionType.HAPI_IS_FROZEN, EvmParsingConstants.FunctionType.GET_TOKEN_DEFAULT_FREEZE_STATUS, EvmParsingConstants.FunctionType.GET_TOKEN_DEFAULT_KYC_STATUS, EvmParsingConstants.FunctionType.HAPI_IS_KYC, EvmParsingConstants.FunctionType.HAPI_IS_TOKEN -> EvmParsingConstants.INT_BOOL_TUPLE;
                case EvmParsingConstants.FunctionType.ERC_NAME, EvmParsingConstants.FunctionType.ERC_SYMBOL, EvmParsingConstants.FunctionType.ERC_TOKEN_URI -> EvmParsingConstants.STRING_TUPLE;
                case EvmParsingConstants.FunctionType.ERC_OWNER, EvmParsingConstants.FunctionType.ERC_GET_APPROVED -> EvmParsingConstants.ADDRESS_TUPLE;
                case EvmParsingConstants.FunctionType.HAPI_GET_TOKEN_INFO -> EvmParsingConstants.GET_TOKEN_INFO_TYPE;
                case EvmParsingConstants.FunctionType.HAPI_GET_FUNGIBLE_TOKEN_INFO -> EvmParsingConstants.GET_FUNGIBLE_TOKEN_INFO_TYPE;
                case EvmParsingConstants.FunctionType.HAPI_GET_NON_FUNGIBLE_TOKEN_INFO -> EvmParsingConstants.GET_NON_FUNGIBLE_TOKEN_INFO_TYPE;
                case EvmParsingConstants.FunctionType.HAPI_GET_TOKEN_CUSTOM_FEES -> EvmParsingConstants.GET_TOKEN_CUSTOM_FEES_TYPE;
                case EvmParsingConstants.FunctionType.HAPI_GET_TOKEN_EXPIRY_INFO -> EvmParsingConstants.GET_TOKEN_EXPIRY_INFO_TYPE;
                case EvmParsingConstants.FunctionType.HAPI_GET_TOKEN_KEY -> EvmParsingConstants.GET_TOKEN_KEY_TYPE;
                default -> EvmParsingConstants.NOT_SPECIFIED_TYPE;
            };
            this.functionType = functionType;
            return this;
        }

        private FunctionResultBuilder withStatus(int status) {
            this.status = status;
            return this;
        }

        private FunctionResultBuilder withDecimals(int decimals) {
            this.decimals = decimals;
            return this;
        }

        private FunctionResultBuilder withGetTokenType(int tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        private FunctionResultBuilder withAllowance(long allowance) {
            this.allowance = allowance;
            return this;
        }

        private FunctionResultBuilder withBalance(long balance) {
            this.balance = balance;
            return this;
        }

        private FunctionResultBuilder withTotalSupply(long totalSupply) {
            this.totalSupply = totalSupply;
            return this;
        }

        private FunctionResultBuilder withIsApprovedForAllStatus(boolean isApprovedForAllStatus) {
            this.isApprovedForAllStatus = isApprovedForAllStatus;
            return this;
        }

        private FunctionResultBuilder withIsFrozen(boolean isFrozen) {
            this.isFrozen = isFrozen;
            return this;
        }

        private FunctionResultBuilder withGetTokenDefaultFreezeStatus(boolean tokenDefaultFreezeStatus) {
            this.tokenDefaultFreezeStatus = tokenDefaultFreezeStatus;
            return this;
        }

        private FunctionResultBuilder withGetTokenDefaultKycStatus(boolean tokenDefaultKycStatus) {
            this.tokenDefaultKycStatus = tokenDefaultKycStatus;
            return this;
        }

        private FunctionResultBuilder withIsKyc(boolean isKyc) {
            this.isKyc = isKyc;
            return this;
        }

        private FunctionResultBuilder withIsToken(boolean isToken) {
            this.isToken = isToken;
            return this;
        }

        private FunctionResultBuilder withName(String name) {
            this.name = name;
            return this;
        }

        private FunctionResultBuilder withSymbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        private FunctionResultBuilder withTokenUri(String tokenUri) {
            this.metadata = tokenUri;
            return this;
        }

        private FunctionResultBuilder withOwner(Address address) {
            this.owner = address;
            return this;
        }

        private FunctionResultBuilder withApproved(Address approved) {
            this.approved = approved;
            return this;
        }

        private FunctionResultBuilder withTokenInfo(EvmTokenInfo tokenInfo) {
            this.tokenInfo = tokenInfo;
            return this;
        }

        private FunctionResultBuilder withCustomFees(List<CustomFee> customFees) {
            this.customFees = customFees;
            return this;
        }

        private FunctionResultBuilder withNftTokenInfo(EvmNftInfo nonFungibleTokenInfo) {
            this.nonFungibleTokenInfo = nonFungibleTokenInfo;
            return this;
        }

        private FunctionResultBuilder withExpiry(TokenExpiryInfo tokenExpiryInfo) {
            this.tokenExpiryInfo = Tuple.of((Object[])new Object[]{tokenExpiryInfo.getSecond(), EvmEncodingFacade.convertBesuAddressToHeadlongAddress(tokenExpiryInfo.getAutoRenewAccount()), tokenExpiryInfo.getAutoRenewPeriod()});
            return this;
        }

        private FunctionResultBuilder withKey(EvmKey wrapper) {
            this.keyValue = Tuple.of((Object[])new Object[]{false, EvmEncodingFacade.convertBesuAddressToHeadlongAddress(wrapper.getContractId()), wrapper.getEd25519(), wrapper.getECDSASecp256K1(), EvmEncodingFacade.convertBesuAddressToHeadlongAddress(wrapper.getDelegatableContractId())});
            return this;
        }

        private Bytes build() {
            Tuple result = switch (this.functionType) {
                case EvmParsingConstants.FunctionType.ERC_DECIMALS -> Tuple.of((Object[])new Object[]{this.decimals});
                case EvmParsingConstants.FunctionType.ERC_ALLOWANCE -> Tuple.of((Object[])new Object[]{BigInteger.valueOf(this.allowance)});
                case EvmParsingConstants.FunctionType.ERC_TOTAL_SUPPLY -> Tuple.of((Object[])new Object[]{BigInteger.valueOf(this.totalSupply)});
                case EvmParsingConstants.FunctionType.ERC_BALANCE -> Tuple.of((Object[])new Object[]{BigInteger.valueOf(this.balance)});
                case EvmParsingConstants.FunctionType.ERC_IS_APPROVED_FOR_ALL -> Tuple.of((Object[])new Object[]{this.isApprovedForAllStatus});
                case EvmParsingConstants.FunctionType.HAPI_IS_FROZEN -> Tuple.of((Object[])new Object[]{this.status, this.isFrozen});
                case EvmParsingConstants.FunctionType.GET_TOKEN_DEFAULT_FREEZE_STATUS -> Tuple.of((Object[])new Object[]{this.status, this.tokenDefaultFreezeStatus});
                case EvmParsingConstants.FunctionType.GET_TOKEN_DEFAULT_KYC_STATUS -> Tuple.of((Object[])new Object[]{this.status, this.tokenDefaultKycStatus});
                case EvmParsingConstants.FunctionType.HAPI_IS_KYC -> Tuple.of((Object[])new Object[]{this.status, this.isKyc});
                case EvmParsingConstants.FunctionType.HAPI_IS_TOKEN -> Tuple.of((Object[])new Object[]{this.status, this.isToken});
                case EvmParsingConstants.FunctionType.HAPI_GET_TOKEN_TYPE -> Tuple.of((Object[])new Object[]{this.status, this.tokenType});
                case EvmParsingConstants.FunctionType.ERC_NAME -> Tuple.of((Object[])new Object[]{this.name});
                case EvmParsingConstants.FunctionType.ERC_SYMBOL -> Tuple.of((Object[])new Object[]{this.symbol});
                case EvmParsingConstants.FunctionType.ERC_TOKEN_URI -> Tuple.of((Object[])new Object[]{this.metadata});
                case EvmParsingConstants.FunctionType.ERC_OWNER -> Tuple.of((Object[])new Object[]{EvmEncodingFacade.convertBesuAddressToHeadlongAddress(this.owner)});
                case EvmParsingConstants.FunctionType.ERC_GET_APPROVED -> Tuple.of((Object[])new Object[]{EvmEncodingFacade.convertBesuAddressToHeadlongAddress(this.approved)});
                case EvmParsingConstants.FunctionType.HAPI_GET_TOKEN_INFO -> this.getTupleForGetTokenInfo();
                case EvmParsingConstants.FunctionType.HAPI_GET_FUNGIBLE_TOKEN_INFO -> this.getTupleForGetFungibleTokenInfo();
                case EvmParsingConstants.FunctionType.HAPI_GET_NON_FUNGIBLE_TOKEN_INFO -> this.getTupleForGetNonFungibleTokenInfo();
                case EvmParsingConstants.FunctionType.HAPI_GET_TOKEN_CUSTOM_FEES -> this.getTupleForTokenGetCustomFees();
                case EvmParsingConstants.FunctionType.HAPI_GET_TOKEN_EXPIRY_INFO -> this.getTupleForGetTokenExpiryInfo();
                case EvmParsingConstants.FunctionType.HAPI_GET_TOKEN_KEY -> Tuple.of((Object[])new Object[]{this.status, this.keyValue});
                default -> Tuple.of((Object[])new Object[]{this.status});
            };
            return Bytes.wrap((byte[])this.tupleType.encode((Object)result).array());
        }

        private Tuple getTupleForGetTokenInfo() {
            return Tuple.of((Object[])new Object[]{this.status, this.getTupleForTokenInfo()});
        }

        private Tuple getTupleForGetFungibleTokenInfo() {
            return Tuple.of((Object[])new Object[]{this.status, Tuple.of((Object[])new Object[]{this.getTupleForTokenInfo(), this.tokenInfo.getDecimals()})});
        }

        private Tuple getTupleForGetNonFungibleTokenInfo() {
            return Tuple.of((Object[])new Object[]{this.status, Tuple.of((Object[])new Object[]{this.getTupleForTokenInfo(), this.nonFungibleTokenInfo.getSerialNumber(), EvmEncodingFacade.convertBesuAddressToHeadlongAddress(this.nonFungibleTokenInfo.getAccount()), this.nonFungibleTokenInfo.getCreationTime(), this.nonFungibleTokenInfo.getMetadata(), EvmEncodingFacade.convertBesuAddressToHeadlongAddress(this.nonFungibleTokenInfo.getSpender())})});
        }

        private Tuple getTupleForTokenGetCustomFees() {
            return this.getTupleForTokenCustomFees(this.status);
        }

        private Tuple getTupleForGetTokenExpiryInfo() {
            return this.getTupleForTokenExpiryInfo(this.status);
        }

        private Tuple getTupleForTokenExpiryInfo(int responseCode) {
            return Tuple.of((Object[])new Object[]{responseCode, this.tokenExpiryInfo});
        }

        private Tuple getTupleForTokenCustomFees(int responseCode) {
            ArrayList<Tuple> fixedFees = new ArrayList<Tuple>();
            ArrayList<Tuple> fractionalFees = new ArrayList<Tuple>();
            ArrayList<Tuple> royaltyFees = new ArrayList<Tuple>();
            for (CustomFee customFee : this.customFees) {
                this.extractAllFees(fixedFees, fractionalFees, royaltyFees, customFee);
            }
            return Tuple.of((Object[])new Object[]{responseCode, fixedFees.toArray(new Tuple[fixedFees.size()]), fractionalFees.toArray(new Tuple[fractionalFees.size()]), royaltyFees.toArray(new Tuple[royaltyFees.size()])});
        }

        private Tuple getTupleForTokenInfo() {
            ArrayList<Tuple> fixedFees = new ArrayList<Tuple>();
            ArrayList<Tuple> fractionalFees = new ArrayList<Tuple>();
            ArrayList<Tuple> royaltyFees = new ArrayList<Tuple>();
            for (CustomFee customFee : this.tokenInfo.getCustomFees()) {
                this.extractAllFees(fixedFees, fractionalFees, royaltyFees, customFee);
            }
            return Tuple.of((Object[])new Object[]{this.getHederaTokenTuple(), this.tokenInfo.getTotalSupply(), this.tokenInfo.isDeleted(), this.tokenInfo.getDefaultKycStatus(), this.tokenInfo.isPaused(), fixedFees.toArray(new Tuple[fixedFees.size()]), fractionalFees.toArray(new Tuple[fractionalFees.size()]), royaltyFees.toArray(new Tuple[royaltyFees.size()]), Bytes.wrap((byte[])this.tokenInfo.getLedgerId()).toString()});
        }

        private Tuple getHederaTokenTuple() {
            long expiry = this.tokenInfo.getExpiry();
            long autoRenewPeriod = this.tokenInfo.getAutoRenewPeriod();
            Tuple expiryTuple = Tuple.of((Object[])new Object[]{expiry, EvmEncodingFacade.convertBesuAddressToHeadlongAddress(this.tokenInfo.getAutoRenewAccount()), autoRenewPeriod});
            return Tuple.of((Object[])new Object[]{this.tokenInfo.getName(), this.tokenInfo.getSymbol(), EvmEncodingFacade.convertBesuAddressToHeadlongAddress(this.tokenInfo.getTreasury()), this.tokenInfo.getMemo(), this.tokenInfo.getSupplyType() == 1, this.tokenInfo.getMaxSupply(), this.tokenInfo.getDefaultFreezeStatus(), this.getTokenKeysTuples(), expiryTuple});
        }

        private Tuple[] getTokenKeysTuples() {
            EvmKey adminKey = this.tokenInfo.getAdminKey();
            EvmKey kycKey = this.tokenInfo.getKycKey();
            EvmKey freezeKey = this.tokenInfo.getFreezeKey();
            EvmKey wipeKey = this.tokenInfo.getWipeKey();
            EvmKey supplyKey = this.tokenInfo.getSupplyKey();
            EvmKey feeScheduleKey = this.tokenInfo.getFeeScheduleKey();
            EvmKey pauseKey = this.tokenInfo.getPauseKey();
            Tuple[] tokenKeysTuples = new Tuple[TokenKeyType.values().length];
            tokenKeysTuples[0] = FunctionResultBuilder.getKeyTuple(BigInteger.valueOf(TokenKeyType.ADMIN_KEY.value()), adminKey);
            tokenKeysTuples[1] = FunctionResultBuilder.getKeyTuple(BigInteger.valueOf(TokenKeyType.KYC_KEY.value()), kycKey);
            tokenKeysTuples[2] = FunctionResultBuilder.getKeyTuple(BigInteger.valueOf(TokenKeyType.FREEZE_KEY.value()), freezeKey);
            tokenKeysTuples[3] = FunctionResultBuilder.getKeyTuple(BigInteger.valueOf(TokenKeyType.WIPE_KEY.value()), wipeKey);
            tokenKeysTuples[4] = FunctionResultBuilder.getKeyTuple(BigInteger.valueOf(TokenKeyType.SUPPLY_KEY.value()), supplyKey);
            tokenKeysTuples[5] = FunctionResultBuilder.getKeyTuple(BigInteger.valueOf(TokenKeyType.FEE_SCHEDULE_KEY.value()), feeScheduleKey);
            tokenKeysTuples[6] = FunctionResultBuilder.getKeyTuple(BigInteger.valueOf(TokenKeyType.PAUSE_KEY.value()), pauseKey);
            return tokenKeysTuples;
        }

        private static Tuple getKeyTuple(BigInteger keyType, @NonNull EvmKey key) {
            return Tuple.of((Object[])new Object[]{keyType, Tuple.of((Object[])new Object[]{false, EvmEncodingFacade.convertBesuAddressToHeadlongAddress(key.getContractId()), key.getEd25519(), key.getECDSASecp256K1(), EvmEncodingFacade.convertBesuAddressToHeadlongAddress(key.getDelegatableContractId())})});
        }

        private void extractAllFees(ArrayList<Tuple> fixedFees, ArrayList<Tuple> fractionalFees, ArrayList<Tuple> royaltyFees, @NonNull CustomFee customFee) {
            if (customFee.getFixedFee() != null) {
                fixedFees.add(this.getFixedFeeTuple(customFee.getFixedFee()));
            } else if (customFee.getFractionalFee() != null) {
                fractionalFees.add(this.getFractionalFeeTuple(customFee.getFractionalFee()));
            } else if (customFee.getRoyaltyFee() != null) {
                royaltyFees.add(this.getRoyaltyFeeTuple(customFee.getRoyaltyFee()));
            }
        }

        private Tuple getFixedFeeTuple(@NonNull FixedFee fixedFee) {
            return Tuple.of((Object[])new Object[]{fixedFee.getAmount(), EvmEncodingFacade.convertBesuAddressToHeadlongAddress(fixedFee.getDenominatingTokenId()), fixedFee.isUseHbarsForPayment(), fixedFee.isUseCurrentTokenForPayment(), EvmEncodingFacade.convertBesuAddressToHeadlongAddress(fixedFee.getFeeCollector())});
        }

        private Tuple getFractionalFeeTuple(@NonNull FractionalFee fractionalFee) {
            return Tuple.of((Object[])new Object[]{fractionalFee.getNumerator(), fractionalFee.getDenominator(), fractionalFee.getMinimumAmount(), fractionalFee.getMaximumAmount(), fractionalFee.getNetOfTransfers(), EvmEncodingFacade.convertBesuAddressToHeadlongAddress(fractionalFee.getFeeCollector())});
        }

        private Tuple getRoyaltyFeeTuple(@NonNull RoyaltyFee royaltyFee) {
            return Tuple.of((Object[])new Object[]{royaltyFee.getNumerator(), royaltyFee.getDenominator(), royaltyFee.getAmount(), EvmEncodingFacade.convertBesuAddressToHeadlongAddress(royaltyFee.getDenominatingTokenId()), royaltyFee.isUseHbarsForPayment(), EvmEncodingFacade.convertBesuAddressToHeadlongAddress(royaltyFee.getFeeCollector())});
        }
    }
}

