/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.store.contracts.precompile.codec;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hyperledger.besu.datatypes.Address;

public class EvmNftInfo {
    private long serialNumber;
    private Address account;
    private long creationTime;
    private byte[] metadata;
    private Address spender;
    private byte[] ledgerId;

    public EvmNftInfo() {
        this.serialNumber = 0L;
        this.account = Address.ZERO;
        this.creationTime = 0L;
        this.metadata = new byte[0];
        this.spender = Address.ZERO;
        this.ledgerId = new byte[0];
    }

    public EvmNftInfo(long serialNumber, @NonNull Address account, long creationTime, byte[] metadata, Address spender, byte[] ledgerId) {
        this.serialNumber = serialNumber;
        this.account = Objects.requireNonNull(account);
        this.creationTime = creationTime;
        this.metadata = metadata;
        this.spender = spender;
        this.ledgerId = ledgerId;
    }

    public long getSerialNumber() {
        return this.serialNumber;
    }

    public Address getAccount() {
        return this.account;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public byte[] getMetadata() {
        return this.metadata;
    }

    public Address getSpender() {
        return this.spender != null ? this.spender : Address.ZERO;
    }

    public byte[] getLedgerId() {
        return this.ledgerId;
    }
}

