/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.store.contracts.precompile.codec;

import java.util.Objects;
import org.hyperledger.besu.datatypes.Address;

public class RoyaltyFee {
    private final long numerator;
    private final long denominator;
    private final long amount;
    private final Address denominatingTokenId;
    private final boolean useHbarsForPayment;
    private final Address feeCollector;

    public RoyaltyFee(long numerator, long denominator, long amount, Address denominatingTokenId, boolean useHbarsForPayment, Address feeCollector) {
        this.numerator = numerator;
        this.denominator = denominator;
        this.amount = amount;
        this.denominatingTokenId = denominatingTokenId;
        this.useHbarsForPayment = useHbarsForPayment;
        this.feeCollector = feeCollector;
    }

    public long getNumerator() {
        return this.numerator;
    }

    public long getDenominator() {
        return this.denominator;
    }

    public long getAmount() {
        return this.amount;
    }

    public Address getDenominatingTokenId() {
        return this.denominatingTokenId != null ? this.denominatingTokenId : Address.ZERO;
    }

    public boolean isUseHbarsForPayment() {
        return this.useHbarsForPayment;
    }

    public Address getFeeCollector() {
        return this.feeCollector != null ? this.feeCollector : Address.ZERO;
    }

    public int hashCode() {
        return Objects.hash(this.numerator, this.denominator, this.amount, this.denominatingTokenId, this.useHbarsForPayment, this.feeCollector);
    }

    public boolean equals(Object o) {
        if (o == null || RoyaltyFee.class != o.getClass()) {
            return false;
        }
        RoyaltyFee other = (RoyaltyFee)o;
        return this.numerator == other.numerator && this.denominator == other.denominator && this.amount == other.amount && this.useHbarsForPayment == other.useHbarsForPayment;
    }

    public String toString() {
        return "RoyaltyFee{numerator=" + this.numerator + ", denominator=" + this.denominator + ", amount=" + this.amount + ", denominatingTokenId=" + String.valueOf(this.denominatingTokenId) + ", useHbarsForPayment=" + this.useHbarsForPayment + ", feeCollector=" + String.valueOf(this.feeCollector) + "}";
    }
}

