/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.store.models;

import com.google.common.base.Preconditions;
import com.hedera.node.app.service.evm.store.UpdateAccountTracker;
import com.hedera.node.app.service.evm.store.contracts.HederaEvmEntityAccess;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.account.AccountStorageEntry;
import org.hyperledger.besu.evm.account.MutableAccount;

public class UpdateTrackingAccount<A extends Account>
implements MutableAccount {
    @Nullable
    protected final A account;
    private final Address address;
    private final Hash addressHash;
    private final UpdateAccountTracker updateAccountTracker;
    private final NavigableMap<UInt256, UInt256> updatedStorage;
    @Nullable
    protected Bytes updatedCode;
    private long nonce;
    private Wei balance;
    private HederaEvmEntityAccess hederaEvmEntityAccess;
    private boolean storageWasCleared = false;
    @Nullable
    private Hash updatedCodeHash;

    public UpdateTrackingAccount(Address address, @Nullable UpdateAccountTracker updateAccountTracker) {
        Preconditions.checkNotNull((Object)address);
        this.address = address;
        this.addressHash = Hash.hash((Bytes)address);
        this.account = null;
        this.balance = Wei.ZERO;
        this.nonce = 0L;
        this.updatedCode = Bytes.EMPTY;
        this.updatedStorage = new TreeMap<UInt256, UInt256>();
        this.updateAccountTracker = updateAccountTracker;
    }

    public UpdateTrackingAccount(A account, @Nullable UpdateAccountTracker updateAccountTracker) {
        Preconditions.checkNotNull(account);
        this.account = account;
        this.address = account.getAddress();
        this.addressHash = account instanceof UpdateTrackingAccount ? ((UpdateTrackingAccount)account).addressHash : Hash.hash((Bytes)account.getAddress());
        this.updateAccountTracker = updateAccountTracker;
        this.balance = account.getBalance();
        this.nonce = account.getNonce();
        this.updatedStorage = new TreeMap<UInt256, UInt256>();
    }

    public A getWrappedAccount() {
        return this.account;
    }

    public boolean codeWasUpdated() {
        return this.updatedCode != null;
    }

    public boolean wrappedAccountIsTokenProxy() {
        return this.account != null && this.account.getNonce() == -1L;
    }

    public Map<UInt256, UInt256> getUpdatedStorage() {
        return this.updatedStorage;
    }

    public Address getAddress() {
        return this.address;
    }

    public Hash getAddressHash() {
        return this.addressHash;
    }

    public long getNonce() {
        return this.nonce;
    }

    public void setNonce(long nonce) {
        this.nonce = nonce;
        if (this.updateAccountTracker != null) {
            this.updateAccountTracker.setNonce(this.address, nonce);
        }
    }

    public Wei getBalance() {
        return this.balance;
    }

    public void setBalance(Wei value) {
        this.balance = value;
        if (this.updateAccountTracker != null) {
            this.updateAccountTracker.setBalance(this.address, value.toLong());
        }
    }

    public void setBalanceFromPropertyChangeObserver(Wei value) {
        this.balance = value;
    }

    public Bytes getCode() {
        return this.updatedCode == null ? this.account.getCode() : this.updatedCode;
    }

    public void setCode(Bytes code) {
        this.updatedCode = code;
        this.updatedCodeHash = null;
    }

    public Hash getCodeHash() {
        if (this.updatedCode == null) {
            return this.account.getCodeHash();
        }
        if (this.updatedCodeHash == null) {
            this.updatedCodeHash = Hash.hash((Bytes)this.updatedCode);
        }
        return this.updatedCodeHash;
    }

    public boolean hasCode() {
        return this.updatedCode == null ? this.account.hasCode() : !this.updatedCode.isEmpty();
    }

    public UInt256 getStorageValue(UInt256 key) {
        UInt256 value = (UInt256)this.updatedStorage.get(key);
        if (value != null) {
            return value;
        }
        if (this.storageWasCleared) {
            return UInt256.ZERO;
        }
        if (this.hederaEvmEntityAccess != null) {
            return this.getStorageValueEvmFlow(key);
        }
        return this.account == null ? UInt256.ZERO : this.account.getStorageValue(key);
    }

    private UInt256 getStorageValueEvmFlow(UInt256 key) {
        UInt256 value = UInt256.fromBytes((Bytes)this.hederaEvmEntityAccess.getStorage(this.address, (Bytes)key.toBytes()));
        this.setStorageValue(key, value);
        return value;
    }

    public UInt256 getOriginalStorageValue(UInt256 key) {
        if (this.storageWasCleared || this.account == null) {
            return UInt256.ZERO;
        }
        return this.account.getOriginalStorageValue(key);
    }

    public NavigableMap<Bytes32, AccountStorageEntry> storageEntriesFrom(Bytes32 startKeyHash, int limit) {
        throw new UnsupportedOperationException();
    }

    public void setStorageValue(UInt256 key, UInt256 value) {
        this.updatedStorage.put(key, value);
    }

    public void clearStorage() {
        this.storageWasCleared = true;
        this.updatedStorage.clear();
    }

    public boolean getStorageWasCleared() {
        return this.storageWasCleared;
    }

    public String toString() {
        String storage;
        String string = storage = this.updatedStorage.isEmpty() ? "[not updated]" : this.updatedStorage.toString();
        if (this.updatedStorage.isEmpty() && this.storageWasCleared) {
            storage = "[cleared]";
        }
        return String.format("%s -> {nonce:%s, balance:%s, code:%s, storage:%s }", this.address, this.nonce, this.balance, this.updatedCode == null ? "[not updated]" : this.updatedCode, storage);
    }

    public void becomeImmutable() {
        throw new UnsupportedOperationException("Not Implemented Yet");
    }

    public void setEvmEntityAccess(HederaEvmEntityAccess hederaEvmEntityAccess) {
        this.hederaEvmEntityAccess = hederaEvmEntityAccess;
    }

    public UpdateAccountTracker getAccountTracker() {
        return this.updateAccountTracker;
    }
}

