/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.codec.AccountIDJsonCodec;
import com.hedera.hapi.node.base.codec.AccountIDProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public record AccountID(long shardNum, long realmNum, OneOf<AccountOneOfType> account) {
    public static final Codec<AccountID> PROTOBUF = new AccountIDProtoCodec();
    public static final JsonCodec<AccountID> JSON = new AccountIDJsonCodec();
    public static final AccountID DEFAULT = AccountID.newBuilder().build();

    public AccountID {
        if (account == null) {
            throw new NullPointerException("Parameter 'account' must be supplied and can not be null");
        }
    }

    @Nullable
    public Long accountNum() {
        return this.account.kind() == AccountOneOfType.ACCOUNT_NUM ? (Long)this.account.value() : null;
    }

    public boolean hasAccountNum() {
        return this.account.kind() == AccountOneOfType.ACCOUNT_NUM;
    }

    public Long accountNumOrElse(@NonNull Long defaultValue) {
        return this.hasAccountNum() ? this.accountNum() : defaultValue;
    }

    @NonNull
    public Long accountNumOrThrow() {
        return Objects.requireNonNull(this.accountNum(), "Field accountNum is null");
    }

    @Nullable
    public Bytes alias() {
        return this.account.kind() == AccountOneOfType.ALIAS ? (Bytes)this.account.value() : null;
    }

    public boolean hasAlias() {
        return this.account.kind() == AccountOneOfType.ALIAS;
    }

    public Bytes aliasOrElse(@NonNull Bytes defaultValue) {
        return this.hasAlias() ? this.alias() : defaultValue;
    }

    @NonNull
    public Bytes aliasOrThrow() {
        return Objects.requireNonNull(this.alias(), "Field alias is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.shardNum, this.realmNum, this.account);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum AccountOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        ACCOUNT_NUM(3, "accountNum"),
        ALIAS(4, "alias");

        private final int protoOrdinal;
        private final String protoName;

        private AccountOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static AccountOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 3 -> ACCOUNT_NUM;
                case 4 -> ALIAS;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static AccountOneOfType fromString(String name) {
            return switch (name) {
                case "ACCOUNT_NUM", "accountNum" -> ACCOUNT_NUM;
                case "ALIAS", "alias" -> ALIAS;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        private long shardNum = 0L;
        private long realmNum = 0L;
        private OneOf<AccountOneOfType> account = AccountIDProtoCodec.ACCOUNT_UNSET;

        public Builder() {
        }

        public Builder(long shardNum, long realmNum, OneOf<AccountOneOfType> account) {
            this.shardNum = shardNum;
            this.realmNum = realmNum;
            this.account = account;
        }

        public AccountID build() {
            return new AccountID(this.shardNum, this.realmNum, this.account);
        }

        public Builder shardNum(long shardNum) {
            this.shardNum = shardNum;
            return this;
        }

        public Builder realmNum(long realmNum) {
            this.realmNum = realmNum;
            return this;
        }

        public Builder accountNum(long accountNum) {
            this.account = new OneOf((Object)AccountOneOfType.ACCOUNT_NUM, (Object)accountNum);
            return this;
        }

        public Builder alias(Bytes alias) {
            this.account = new OneOf((Object)AccountOneOfType.ALIAS, (Object)alias);
            return this;
        }
    }
}

