/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.hapi.node.base.codec.NodeAddressJsonCodec;
import com.hedera.hapi.node.base.codec.NodeAddressProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record NodeAddress(Bytes ipAddress, int portno, Bytes memo, String rsaPubKey, long nodeId, @Nullable AccountID nodeAccountId, Bytes nodeCertHash, @Nullable List<ServiceEndpoint> serviceEndpoint, String description, long stake) {
    public static final Codec<NodeAddress> PROTOBUF = new NodeAddressProtoCodec();
    public static final JsonCodec<NodeAddress> JSON = new NodeAddressJsonCodec();
    public static final NodeAddress DEFAULT = NodeAddress.newBuilder().build();

    public boolean hasNodeAccountId() {
        return this.nodeAccountId != null;
    }

    public AccountID nodeAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasNodeAccountId() ? this.nodeAccountId : defaultValue;
    }

    @NonNull
    public AccountID nodeAccountIdOrThrow() {
        return Objects.requireNonNull(this.nodeAccountId, "Field nodeAccountId is null");
    }

    public void ifNodeAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasNodeAccountId()) {
            ifPresent.accept(this.nodeAccountId);
        }
    }

    public boolean hasServiceEndpoint() {
        return this.serviceEndpoint != null;
    }

    public List<ServiceEndpoint> serviceEndpointOrElse(@NonNull List<ServiceEndpoint> defaultValue) {
        return this.hasServiceEndpoint() ? this.serviceEndpoint : defaultValue;
    }

    @NonNull
    public List<ServiceEndpoint> serviceEndpointOrThrow() {
        return Objects.requireNonNull(this.serviceEndpoint, "Field serviceEndpoint is null");
    }

    public void ifServiceEndpoint(@NonNull Consumer<List<ServiceEndpoint>> ifPresent) {
        if (this.hasServiceEndpoint()) {
            ifPresent.accept(this.serviceEndpoint);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.ipAddress, this.portno, this.memo, this.rsaPubKey, this.nodeId, this.nodeAccountId, this.nodeCertHash, this.serviceEndpoint, this.description, this.stake);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Bytes ipAddress = Bytes.EMPTY;
        private int portno = 0;
        private Bytes memo = Bytes.EMPTY;
        private String rsaPubKey = "";
        private long nodeId = 0L;
        private AccountID nodeAccountId = null;
        private Bytes nodeCertHash = Bytes.EMPTY;
        private List<ServiceEndpoint> serviceEndpoint = Collections.emptyList();
        private String description = "";
        private long stake = 0L;

        public Builder() {
        }

        public Builder(Bytes ipAddress, int portno, Bytes memo, String rsaPubKey, long nodeId, AccountID nodeAccountId, Bytes nodeCertHash, List<ServiceEndpoint> serviceEndpoint, String description, long stake) {
            this.ipAddress = ipAddress;
            this.portno = portno;
            this.memo = memo;
            this.rsaPubKey = rsaPubKey;
            this.nodeId = nodeId;
            this.nodeAccountId = nodeAccountId;
            this.nodeCertHash = nodeCertHash;
            this.serviceEndpoint = serviceEndpoint;
            this.description = description;
            this.stake = stake;
        }

        public NodeAddress build() {
            return new NodeAddress(this.ipAddress, this.portno, this.memo, this.rsaPubKey, this.nodeId, this.nodeAccountId, this.nodeCertHash, this.serviceEndpoint, this.description, this.stake);
        }

        public Builder ipAddress(Bytes ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder portno(int portno) {
            this.portno = portno;
            return this;
        }

        public Builder memo(Bytes memo) {
            this.memo = memo;
            return this;
        }

        public Builder rsaPubKey(String rsaPubKey) {
            this.rsaPubKey = rsaPubKey;
            return this;
        }

        public Builder nodeId(long nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder nodeAccountId(AccountID nodeAccountId) {
            this.nodeAccountId = nodeAccountId;
            return this;
        }

        public Builder nodeAccountId(AccountID.Builder builder) {
            this.nodeAccountId = builder.build();
            return this;
        }

        public Builder nodeCertHash(Bytes nodeCertHash) {
            this.nodeCertHash = nodeCertHash;
            return this;
        }

        public Builder serviceEndpoint(List<ServiceEndpoint> serviceEndpoint) {
            this.serviceEndpoint = serviceEndpoint;
            return this;
        }

        public Builder serviceEndpoint(ServiceEndpoint ... values) {
            this.serviceEndpoint = List.of(values);
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder stake(long stake) {
            this.stake = stake;
            return this;
        }
    }
}

