/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.ResponseType;
import com.hedera.hapi.node.base.Transaction;
import com.hedera.hapi.node.base.codec.QueryHeaderJsonCodec;
import com.hedera.hapi.node.base.codec.QueryHeaderProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record QueryHeader(@Nullable Transaction payment, ResponseType responseType) {
    public static final Codec<QueryHeader> PROTOBUF = new QueryHeaderProtoCodec();
    public static final JsonCodec<QueryHeader> JSON = new QueryHeaderJsonCodec();
    public static final QueryHeader DEFAULT = QueryHeader.newBuilder().build();

    public boolean hasPayment() {
        return this.payment != null;
    }

    public Transaction paymentOrElse(@NonNull Transaction defaultValue) {
        return this.hasPayment() ? this.payment : defaultValue;
    }

    @NonNull
    public Transaction paymentOrThrow() {
        return Objects.requireNonNull(this.payment, "Field payment is null");
    }

    public void ifPayment(@NonNull Consumer<Transaction> ifPresent) {
        if (this.hasPayment()) {
            ifPresent.accept(this.payment);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.payment, this.responseType);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Transaction payment = null;
        private ResponseType responseType = ResponseType.values()[0];

        public Builder() {
        }

        public Builder(Transaction payment, ResponseType responseType) {
            this.payment = payment;
            this.responseType = responseType;
        }

        public QueryHeader build() {
            return new QueryHeader(this.payment, this.responseType);
        }

        public Builder payment(Transaction payment) {
            this.payment = payment;
            return this;
        }

        public Builder payment(Transaction.Builder builder) {
            this.payment = builder.build();
            return this;
        }

        public Builder responseType(ResponseType responseType) {
            this.responseType = responseType;
            return this;
        }
    }
}

