/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.SignatureList;
import com.hedera.hapi.node.base.SignatureMap;
import com.hedera.hapi.node.base.codec.TransactionJsonCodec;
import com.hedera.hapi.node.base.codec.TransactionProtoCodec;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record Transaction(@Nullable TransactionBody body, @Nullable SignatureList sigs, @Nullable SignatureMap sigMap, Bytes bodyBytes, Bytes signedTransactionBytes) {
    public static final Codec<Transaction> PROTOBUF = new TransactionProtoCodec();
    public static final JsonCodec<Transaction> JSON = new TransactionJsonCodec();
    public static final Transaction DEFAULT = Transaction.newBuilder().build();

    public boolean hasBody() {
        return this.body != null;
    }

    public TransactionBody bodyOrElse(@NonNull TransactionBody defaultValue) {
        return this.hasBody() ? this.body : defaultValue;
    }

    @NonNull
    public TransactionBody bodyOrThrow() {
        return Objects.requireNonNull(this.body, "Field body is null");
    }

    public void ifBody(@NonNull Consumer<TransactionBody> ifPresent) {
        if (this.hasBody()) {
            ifPresent.accept(this.body);
        }
    }

    public boolean hasSigs() {
        return this.sigs != null;
    }

    public SignatureList sigsOrElse(@NonNull SignatureList defaultValue) {
        return this.hasSigs() ? this.sigs : defaultValue;
    }

    @NonNull
    public SignatureList sigsOrThrow() {
        return Objects.requireNonNull(this.sigs, "Field sigs is null");
    }

    public void ifSigs(@NonNull Consumer<SignatureList> ifPresent) {
        if (this.hasSigs()) {
            ifPresent.accept(this.sigs);
        }
    }

    public boolean hasSigMap() {
        return this.sigMap != null;
    }

    public SignatureMap sigMapOrElse(@NonNull SignatureMap defaultValue) {
        return this.hasSigMap() ? this.sigMap : defaultValue;
    }

    @NonNull
    public SignatureMap sigMapOrThrow() {
        return Objects.requireNonNull(this.sigMap, "Field sigMap is null");
    }

    public void ifSigMap(@NonNull Consumer<SignatureMap> ifPresent) {
        if (this.hasSigMap()) {
            ifPresent.accept(this.sigMap);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.body, this.sigs, this.sigMap, this.bodyBytes, this.signedTransactionBytes);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private TransactionBody body = null;
        private SignatureList sigs = null;
        private SignatureMap sigMap = null;
        private Bytes bodyBytes = Bytes.EMPTY;
        private Bytes signedTransactionBytes = Bytes.EMPTY;

        public Builder() {
        }

        public Builder(TransactionBody body, SignatureList sigs, SignatureMap sigMap, Bytes bodyBytes, Bytes signedTransactionBytes) {
            this.body = body;
            this.sigs = sigs;
            this.sigMap = sigMap;
            this.bodyBytes = bodyBytes;
            this.signedTransactionBytes = signedTransactionBytes;
        }

        public Transaction build() {
            return new Transaction(this.body, this.sigs, this.sigMap, this.bodyBytes, this.signedTransactionBytes);
        }

        public Builder body(TransactionBody body) {
            this.body = body;
            return this;
        }

        public Builder body(TransactionBody.Builder builder) {
            this.body = builder.build();
            return this;
        }

        public Builder sigs(SignatureList sigs) {
            this.sigs = sigs;
            return this;
        }

        public Builder sigs(SignatureList.Builder builder) {
            this.sigs = builder.build();
            return this;
        }

        public Builder sigMap(SignatureMap sigMap) {
            this.sigMap = sigMap;
            return this;
        }

        public Builder sigMap(SignatureMap.Builder builder) {
            this.sigMap = builder.build();
            return this;
        }

        public Builder bodyBytes(Bytes bodyBytes) {
            this.bodyBytes = bodyBytes;
            return this;
        }

        public Builder signedTransactionBytes(Bytes signedTransactionBytes) {
            this.signedTransactionBytes = signedTransactionBytes;
            return this;
        }
    }
}

