/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.FeeData;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.codec.TransactionFeeScheduleJsonCodec;
import com.hedera.hapi.node.base.codec.TransactionFeeScheduleProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record TransactionFeeSchedule(HederaFunctionality hederaFunctionality, @Nullable FeeData feeData, @Nullable List<FeeData> fees) {
    public static final Codec<TransactionFeeSchedule> PROTOBUF = new TransactionFeeScheduleProtoCodec();
    public static final JsonCodec<TransactionFeeSchedule> JSON = new TransactionFeeScheduleJsonCodec();
    public static final TransactionFeeSchedule DEFAULT = TransactionFeeSchedule.newBuilder().build();

    public boolean hasFeeData() {
        return this.feeData != null;
    }

    public FeeData feeDataOrElse(@NonNull FeeData defaultValue) {
        return this.hasFeeData() ? this.feeData : defaultValue;
    }

    @NonNull
    public FeeData feeDataOrThrow() {
        return Objects.requireNonNull(this.feeData, "Field feeData is null");
    }

    public void ifFeeData(@NonNull Consumer<FeeData> ifPresent) {
        if (this.hasFeeData()) {
            ifPresent.accept(this.feeData);
        }
    }

    public boolean hasFees() {
        return this.fees != null;
    }

    public List<FeeData> feesOrElse(@NonNull List<FeeData> defaultValue) {
        return this.hasFees() ? this.fees : defaultValue;
    }

    @NonNull
    public List<FeeData> feesOrThrow() {
        return Objects.requireNonNull(this.fees, "Field fees is null");
    }

    public void ifFees(@NonNull Consumer<List<FeeData>> ifPresent) {
        if (this.hasFees()) {
            ifPresent.accept(this.fees);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.hederaFunctionality, this.feeData, this.fees);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private HederaFunctionality hederaFunctionality = HederaFunctionality.values()[0];
        private FeeData feeData = null;
        private List<FeeData> fees = Collections.emptyList();

        public Builder() {
        }

        public Builder(HederaFunctionality hederaFunctionality, FeeData feeData, List<FeeData> fees) {
            this.hederaFunctionality = hederaFunctionality;
            this.feeData = feeData;
            this.fees = fees;
        }

        public TransactionFeeSchedule build() {
            return new TransactionFeeSchedule(this.hederaFunctionality, this.feeData, this.fees);
        }

        public Builder hederaFunctionality(HederaFunctionality hederaFunctionality) {
            this.hederaFunctionality = hederaFunctionality;
            return this;
        }

        public Builder feeData(FeeData feeData) {
            this.feeData = feeData;
            return this;
        }

        public Builder feeData(FeeData.Builder builder) {
            this.feeData = builder.build();
            return this;
        }

        public Builder fees(List<FeeData> fees) {
            this.fees = fees;
            return this;
        }

        public Builder fees(FeeData ... values) {
            this.fees = List.of(values);
            return this;
        }
    }
}

