/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.codec.TransactionIDJsonCodec;
import com.hedera.hapi.node.base.codec.TransactionIDProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record TransactionID(@Nullable Timestamp transactionValidStart, @Nullable AccountID accountID, boolean scheduled, int nonce) {
    public static final Codec<TransactionID> PROTOBUF = new TransactionIDProtoCodec();
    public static final JsonCodec<TransactionID> JSON = new TransactionIDJsonCodec();
    public static final TransactionID DEFAULT = TransactionID.newBuilder().build();

    public boolean hasTransactionValidStart() {
        return this.transactionValidStart != null;
    }

    public Timestamp transactionValidStartOrElse(@NonNull Timestamp defaultValue) {
        return this.hasTransactionValidStart() ? this.transactionValidStart : defaultValue;
    }

    @NonNull
    public Timestamp transactionValidStartOrThrow() {
        return Objects.requireNonNull(this.transactionValidStart, "Field transactionValidStart is null");
    }

    public void ifTransactionValidStart(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasTransactionValidStart()) {
            ifPresent.accept(this.transactionValidStart);
        }
    }

    public boolean hasAccountID() {
        return this.accountID != null;
    }

    public AccountID accountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccountID() ? this.accountID : defaultValue;
    }

    @NonNull
    public AccountID accountIDOrThrow() {
        return Objects.requireNonNull(this.accountID, "Field accountID is null");
    }

    public void ifAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAccountID()) {
            ifPresent.accept(this.accountID);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.transactionValidStart, this.accountID, this.scheduled, this.nonce);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Timestamp transactionValidStart = null;
        private AccountID accountID = null;
        private boolean scheduled = false;
        private int nonce = 0;

        public Builder() {
        }

        public Builder(Timestamp transactionValidStart, AccountID accountID, boolean scheduled, int nonce) {
            this.transactionValidStart = transactionValidStart;
            this.accountID = accountID;
            this.scheduled = scheduled;
            this.nonce = nonce;
        }

        public TransactionID build() {
            return new TransactionID(this.transactionValidStart, this.accountID, this.scheduled, this.nonce);
        }

        public Builder transactionValidStart(Timestamp transactionValidStart) {
            this.transactionValidStart = transactionValidStart;
            return this;
        }

        public Builder transactionValidStart(Timestamp.Builder builder) {
            this.transactionValidStart = builder.build();
            return this;
        }

        public Builder accountID(AccountID accountID) {
            this.accountID = accountID;
            return this;
        }

        public Builder accountID(AccountID.Builder builder) {
            this.accountID = builder.build();
            return this;
        }

        public Builder scheduled(boolean scheduled) {
            this.scheduled = scheduled;
            return this;
        }

        public Builder nonce(int nonce) {
            this.nonce = nonce;
            return this;
        }
    }
}

