/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.ThresholdKey;
import com.hedera.hapi.node.base.schema.KeySchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class KeyProtoCodec
implements Codec<Key> {
    public static final OneOf<Key.KeyOneOfType> KEY_UNSET = new OneOf((Object)Key.KeyOneOfType.UNSET, null);

    @NonNull
    public Key parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public Key parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull Key data, @NonNull WritableSequentialData out) throws IOException {
        if (data.key().kind() == Key.KeyOneOfType.CONTRACT_ID) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)KeySchema.CONTRACT_ID, (Object)((ContractID)data.key().as()), (arg_0, arg_1) -> ContractID.PROTOBUF.write(arg_0, arg_1), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        }
        if (data.key().kind() == Key.KeyOneOfType.ED25519) {
            ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)KeySchema.ED25519, (RandomAccessData)((RandomAccessData)data.key().as()));
        }
        if (data.key().kind() == Key.KeyOneOfType.RSA_3072) {
            ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)KeySchema.RSA_3072, (RandomAccessData)((RandomAccessData)data.key().as()));
        }
        if (data.key().kind() == Key.KeyOneOfType.ECDSA_384) {
            ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)KeySchema.ECDSA_384, (RandomAccessData)((RandomAccessData)data.key().as()));
        }
        if (data.key().kind() == Key.KeyOneOfType.THRESHOLD_KEY) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)KeySchema.THRESHOLD_KEY, (Object)((ThresholdKey)data.key().as()), (arg_0, arg_1) -> ThresholdKey.PROTOBUF.write(arg_0, arg_1), arg_0 -> ThresholdKey.PROTOBUF.measureRecord(arg_0));
        }
        if (data.key().kind() == Key.KeyOneOfType.KEY_LIST) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)KeySchema.KEY_LIST, (Object)((KeyList)data.key().as()), (arg_0, arg_1) -> KeyList.PROTOBUF.write(arg_0, arg_1), arg_0 -> KeyList.PROTOBUF.measureRecord(arg_0));
        }
        if (data.key().kind() == Key.KeyOneOfType.ECDSA_SECP256K1) {
            ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)KeySchema.ECDSA_SECP256K1, (RandomAccessData)((RandomAccessData)data.key().as()));
        }
        if (data.key().kind() == Key.KeyOneOfType.DELEGATABLE_CONTRACT_ID) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)KeySchema.DELEGATABLE_CONTRACT_ID, (Object)((ContractID)data.key().as()), (arg_0, arg_1) -> ContractID.PROTOBUF.write(arg_0, arg_1), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        }
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(Key data) {
        int size = 0;
        if (data.key().kind() == Key.KeyOneOfType.CONTRACT_ID) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)KeySchema.CONTRACT_ID, (Object)((ContractID)data.key().as()), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        }
        if (data.key().kind() == Key.KeyOneOfType.ED25519) {
            size += ProtoWriterTools.sizeOfBytes((FieldDefinition)KeySchema.ED25519, (RandomAccessData)((RandomAccessData)data.key().as()));
        }
        if (data.key().kind() == Key.KeyOneOfType.RSA_3072) {
            size += ProtoWriterTools.sizeOfBytes((FieldDefinition)KeySchema.RSA_3072, (RandomAccessData)((RandomAccessData)data.key().as()));
        }
        if (data.key().kind() == Key.KeyOneOfType.ECDSA_384) {
            size += ProtoWriterTools.sizeOfBytes((FieldDefinition)KeySchema.ECDSA_384, (RandomAccessData)((RandomAccessData)data.key().as()));
        }
        if (data.key().kind() == Key.KeyOneOfType.THRESHOLD_KEY) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)KeySchema.THRESHOLD_KEY, (Object)((ThresholdKey)data.key().as()), arg_0 -> ThresholdKey.PROTOBUF.measureRecord(arg_0));
        }
        if (data.key().kind() == Key.KeyOneOfType.KEY_LIST) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)KeySchema.KEY_LIST, (Object)((KeyList)data.key().as()), arg_0 -> KeyList.PROTOBUF.measureRecord(arg_0));
        }
        if (data.key().kind() == Key.KeyOneOfType.ECDSA_SECP256K1) {
            size += ProtoWriterTools.sizeOfBytes((FieldDefinition)KeySchema.ECDSA_SECP256K1, (RandomAccessData)((RandomAccessData)data.key().as()));
        }
        if (data.key().kind() == Key.KeyOneOfType.DELEGATABLE_CONTRACT_ID) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)KeySchema.DELEGATABLE_CONTRACT_ID, (Object)((ContractID)data.key().as()), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        }
        return size;
    }

    public boolean fastEquals(@NonNull Key item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private Key parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        OneOf temp_key = KEY_UNSET;
        try {
            block12: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = KeySchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (ContractID)ContractID.PROTOBUF.parseStrict(input) : (ContractID)ContractID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_key = new OneOf((Object)Key.KeyOneOfType.CONTRACT_ID, (Object)value);
                        continue block12;
                    }
                    case 18: {
                        Bytes value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        temp_key = new OneOf((Object)Key.KeyOneOfType.ED25519, (Object)value);
                        continue block12;
                    }
                    case 26: {
                        Bytes value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        temp_key = new OneOf((Object)Key.KeyOneOfType.RSA_3072, (Object)value);
                        continue block12;
                    }
                    case 34: {
                        Bytes value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        temp_key = new OneOf((Object)Key.KeyOneOfType.ECDSA_384, (Object)value);
                        continue block12;
                    }
                    case 42: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (ThresholdKey)ThresholdKey.PROTOBUF.parseStrict(input) : (ThresholdKey)ThresholdKey.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_key = new OneOf((Object)Key.KeyOneOfType.THRESHOLD_KEY, (Object)value);
                        continue block12;
                    }
                    case 50: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (KeyList)KeyList.PROTOBUF.parseStrict(input) : (KeyList)KeyList.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_key = new OneOf((Object)Key.KeyOneOfType.KEY_LIST, (Object)value);
                        continue block12;
                    }
                    case 58: {
                        Bytes value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        temp_key = new OneOf((Object)Key.KeyOneOfType.ECDSA_SECP256K1, (Object)value);
                        continue block12;
                    }
                    case 66: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (ContractID)ContractID.PROTOBUF.parseStrict(input) : (ContractID)ContractID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_key = new OneOf((Object)Key.KeyOneOfType.DELEGATABLE_CONTRACT_ID, (Object)value);
                        continue block12;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new Key(temp_key);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new Key(temp_key);
    }
}

