/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.NodeAddress;
import com.hedera.hapi.node.base.NodeAddressBook;
import com.hedera.hapi.node.base.schema.NodeAddressBookSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class NodeAddressBookProtoCodec
implements Codec<NodeAddressBook> {
    @NonNull
    public NodeAddressBook parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public NodeAddressBook parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull NodeAddressBook data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)NodeAddressBookSchema.NODE_ADDRESS, data.nodeAddress(), (arg_0, arg_1) -> NodeAddress.PROTOBUF.write(arg_0, arg_1), arg_0 -> NodeAddress.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(NodeAddressBook data) {
        int size = 0;
        return size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)NodeAddressBookSchema.NODE_ADDRESS, data.nodeAddress(), arg_0 -> NodeAddress.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull NodeAddressBook item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private NodeAddressBook parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        List temp_nodeAddress = Collections.emptyList();
        try {
            block5: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = NodeAddressBookSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        NodeAddress value = strictMode ? (NodeAddress)NodeAddress.PROTOBUF.parseStrict(input) : (NodeAddress)NodeAddress.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_nodeAddress = ProtoParserTools.addToList(temp_nodeAddress, (Object)value);
                        continue block5;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new NodeAddressBook(temp_nodeAddress);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new NodeAddressBook(temp_nodeAddress);
    }
}

