/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.Signature;
import com.hedera.hapi.node.base.SignatureList;
import com.hedera.hapi.node.base.schema.SignatureListSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class SignatureListProtoCodec
implements Codec<SignatureList> {
    @NonNull
    public SignatureList parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public SignatureList parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull SignatureList data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)SignatureListSchema.SIGS, data.sigs(), (arg_0, arg_1) -> Signature.PROTOBUF.write(arg_0, arg_1), arg_0 -> Signature.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(SignatureList data) {
        int size = 0;
        return size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)SignatureListSchema.SIGS, data.sigs(), arg_0 -> Signature.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull SignatureList item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private SignatureList parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        List temp_sigs = Collections.emptyList();
        try {
            block5: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = SignatureListSchema.getField(field);
                switch (tag) {
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Signature value = strictMode ? (Signature)Signature.PROTOBUF.parseStrict(input) : (Signature)Signature.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_sigs = ProtoParserTools.addToList(temp_sigs, (Object)value);
                        continue block5;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new SignatureList(temp_sigs);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new SignatureList(temp_sigs);
    }
}

