/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.SignaturePair;
import com.hedera.hapi.node.base.schema.SignaturePairSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class SignaturePairProtoCodec
implements Codec<SignaturePair> {
    public static final OneOf<SignaturePair.SignatureOneOfType> SIGNATURE_UNSET = new OneOf((Object)SignaturePair.SignatureOneOfType.UNSET, null);

    @NonNull
    public SignaturePair parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public SignaturePair parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull SignaturePair data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)SignaturePairSchema.PUB_KEY_PREFIX, (RandomAccessData)data.pubKeyPrefix());
        if (data.signature().kind() == SignaturePair.SignatureOneOfType.CONTRACT) {
            ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)SignaturePairSchema.CONTRACT, (RandomAccessData)((RandomAccessData)data.signature().as()));
        }
        if (data.signature().kind() == SignaturePair.SignatureOneOfType.ED25519) {
            ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)SignaturePairSchema.ED25519, (RandomAccessData)((RandomAccessData)data.signature().as()));
        }
        if (data.signature().kind() == SignaturePair.SignatureOneOfType.RSA_3072) {
            ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)SignaturePairSchema.RSA_3072, (RandomAccessData)((RandomAccessData)data.signature().as()));
        }
        if (data.signature().kind() == SignaturePair.SignatureOneOfType.ECDSA_384) {
            ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)SignaturePairSchema.ECDSA_384, (RandomAccessData)((RandomAccessData)data.signature().as()));
        }
        if (data.signature().kind() == SignaturePair.SignatureOneOfType.ECDSA_SECP256K1) {
            ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)SignaturePairSchema.ECDSA_SECP256K1, (RandomAccessData)((RandomAccessData)data.signature().as()));
        }
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(SignaturePair data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)SignaturePairSchema.PUB_KEY_PREFIX, (RandomAccessData)data.pubKeyPrefix());
        if (data.signature().kind() == SignaturePair.SignatureOneOfType.CONTRACT) {
            size += ProtoWriterTools.sizeOfBytes((FieldDefinition)SignaturePairSchema.CONTRACT, (RandomAccessData)((RandomAccessData)data.signature().as()));
        }
        if (data.signature().kind() == SignaturePair.SignatureOneOfType.ED25519) {
            size += ProtoWriterTools.sizeOfBytes((FieldDefinition)SignaturePairSchema.ED25519, (RandomAccessData)((RandomAccessData)data.signature().as()));
        }
        if (data.signature().kind() == SignaturePair.SignatureOneOfType.RSA_3072) {
            size += ProtoWriterTools.sizeOfBytes((FieldDefinition)SignaturePairSchema.RSA_3072, (RandomAccessData)((RandomAccessData)data.signature().as()));
        }
        if (data.signature().kind() == SignaturePair.SignatureOneOfType.ECDSA_384) {
            size += ProtoWriterTools.sizeOfBytes((FieldDefinition)SignaturePairSchema.ECDSA_384, (RandomAccessData)((RandomAccessData)data.signature().as()));
        }
        if (data.signature().kind() == SignaturePair.SignatureOneOfType.ECDSA_SECP256K1) {
            size += ProtoWriterTools.sizeOfBytes((FieldDefinition)SignaturePairSchema.ECDSA_SECP256K1, (RandomAccessData)((RandomAccessData)data.signature().as()));
        }
        return size;
    }

    public boolean fastEquals(@NonNull SignaturePair item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private SignaturePair parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Bytes temp_pubKeyPrefix = Bytes.EMPTY;
        OneOf temp_signature = SIGNATURE_UNSET;
        try {
            block10: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = SignaturePairSchema.getField(field);
                switch (tag) {
                    case 10: {
                        Bytes value;
                        temp_pubKeyPrefix = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block10;
                    }
                    case 18: {
                        Bytes value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        temp_signature = new OneOf((Object)SignaturePair.SignatureOneOfType.CONTRACT, (Object)value);
                        continue block10;
                    }
                    case 26: {
                        Bytes value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        temp_signature = new OneOf((Object)SignaturePair.SignatureOneOfType.ED25519, (Object)value);
                        continue block10;
                    }
                    case 34: {
                        Bytes value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        temp_signature = new OneOf((Object)SignaturePair.SignatureOneOfType.RSA_3072, (Object)value);
                        continue block10;
                    }
                    case 42: {
                        Bytes value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        temp_signature = new OneOf((Object)SignaturePair.SignatureOneOfType.ECDSA_384, (Object)value);
                        continue block10;
                    }
                    case 50: {
                        Bytes value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        temp_signature = new OneOf((Object)SignaturePair.SignatureOneOfType.ECDSA_SECP256K1, (Object)value);
                        continue block10;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new SignaturePair(temp_pubKeyPrefix, temp_signature);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new SignaturePair(temp_pubKeyPrefix, temp_signature);
    }
}

