/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.StakingInfo;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.schema.StakingInfoSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class StakingInfoProtoCodec
implements Codec<StakingInfo> {
    public static final OneOf<StakingInfo.StakedIdOneOfType> STAKED_ID_UNSET = new OneOf((Object)StakingInfo.StakedIdOneOfType.UNSET, null);

    @NonNull
    public StakingInfo parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public StakingInfo parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull StakingInfo data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)StakingInfoSchema.DECLINE_REWARD, (boolean)data.declineReward());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)StakingInfoSchema.STAKE_PERIOD_START, (Object)data.stakePeriodStart(), (arg_0, arg_1) -> Timestamp.PROTOBUF.write(arg_0, arg_1), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)StakingInfoSchema.PENDING_REWARD, (long)data.pendingReward());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)StakingInfoSchema.STAKED_TO_ME, (long)data.stakedToMe());
        if (data.stakedId().kind() == StakingInfo.StakedIdOneOfType.STAKED_ACCOUNT_ID) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)StakingInfoSchema.STAKED_ACCOUNT_ID, (Object)((AccountID)data.stakedId().as()), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        }
        if (data.stakedId().kind() == StakingInfo.StakedIdOneOfType.STAKED_NODE_ID) {
            ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)StakingInfoSchema.STAKED_NODE_ID, (long)((Long)data.stakedId().as()));
        }
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(StakingInfo data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)StakingInfoSchema.DECLINE_REWARD, (boolean)data.declineReward());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)StakingInfoSchema.STAKE_PERIOD_START, (Object)data.stakePeriodStart(), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)StakingInfoSchema.PENDING_REWARD, (long)data.pendingReward());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)StakingInfoSchema.STAKED_TO_ME, (long)data.stakedToMe());
        if (data.stakedId().kind() == StakingInfo.StakedIdOneOfType.STAKED_ACCOUNT_ID) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)StakingInfoSchema.STAKED_ACCOUNT_ID, (Object)((AccountID)data.stakedId().as()), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        }
        if (data.stakedId().kind() == StakingInfo.StakedIdOneOfType.STAKED_NODE_ID) {
            size += ProtoWriterTools.sizeOfLong((FieldDefinition)StakingInfoSchema.STAKED_NODE_ID, (long)((Long)data.stakedId().as()));
        }
        return size;
    }

    public boolean fastEquals(@NonNull StakingInfo item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private StakingInfo parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        boolean temp_decline_reward = false;
        Record temp_stake_period_start = null;
        long temp_pending_reward = 0L;
        long temp_staked_to_me = 0L;
        OneOf temp_staked_id = STAKED_ID_UNSET;
        try {
            block10: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = StakingInfoSchema.getField(field);
                switch (tag) {
                    case 8: {
                        boolean value;
                        temp_decline_reward = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block10;
                    }
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Timestamp)Timestamp.PROTOBUF.parseStrict(input) : (Timestamp)Timestamp.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_stake_period_start = value;
                        continue block10;
                    }
                    case 24: {
                        long value;
                        temp_pending_reward = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block10;
                    }
                    case 32: {
                        long value;
                        temp_staked_to_me = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block10;
                    }
                    case 42: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_staked_id = new OneOf((Object)StakingInfo.StakedIdOneOfType.STAKED_ACCOUNT_ID, (Object)value);
                        continue block10;
                    }
                    case 48: {
                        long value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        temp_staked_id = new OneOf((Object)StakingInfo.StakedIdOneOfType.STAKED_NODE_ID, (Object)value);
                        continue block10;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new StakingInfo(temp_decline_reward, (Timestamp)temp_stake_period_start, temp_pending_reward, temp_staked_to_me, (OneOf<StakingInfo.StakedIdOneOfType>)temp_staked_id);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new StakingInfo(temp_decline_reward, (Timestamp)temp_stake_period_start, temp_pending_reward, temp_staked_to_me, (OneOf<StakingInfo.StakedIdOneOfType>)temp_staked_id);
    }
}

