/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.SignatureList;
import com.hedera.hapi.node.base.ThresholdSignature;
import com.hedera.hapi.node.base.schema.ThresholdSignatureSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class ThresholdSignatureProtoCodec
implements Codec<ThresholdSignature> {
    @NonNull
    public ThresholdSignature parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public ThresholdSignature parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull ThresholdSignature data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ThresholdSignatureSchema.SIGS, (Object)data.sigs(), (arg_0, arg_1) -> SignatureList.PROTOBUF.write(arg_0, arg_1), arg_0 -> SignatureList.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(ThresholdSignature data) {
        int size = 0;
        return size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ThresholdSignatureSchema.SIGS, (Object)data.sigs(), arg_0 -> SignatureList.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull ThresholdSignature item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private ThresholdSignature parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        SignatureList temp_sigs = null;
        try {
            block5: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = ThresholdSignatureSchema.getField(field);
                switch (tag) {
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        SignatureList value = strictMode ? (SignatureList)SignatureList.PROTOBUF.parseStrict(input) : (SignatureList)SignatureList.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_sigs = value;
                        continue block5;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new ThresholdSignature(temp_sigs);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new ThresholdSignature(temp_sigs);
    }
}

