/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.schema.TokenTransferListSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class TokenTransferListProtoCodec
implements Codec<TokenTransferList> {
    @NonNull
    public TokenTransferList parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public TokenTransferList parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull TokenTransferList data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TokenTransferListSchema.TOKEN, (Object)data.token(), (arg_0, arg_1) -> TokenID.PROTOBUF.write(arg_0, arg_1), arg_0 -> TokenID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)TokenTransferListSchema.TRANSFERS, data.transfers(), (arg_0, arg_1) -> AccountAmount.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountAmount.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)TokenTransferListSchema.NFT_TRANSFERS, data.nftTransfers(), (arg_0, arg_1) -> NftTransfer.PROTOBUF.write(arg_0, arg_1), arg_0 -> NftTransfer.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeOptionalInteger((WritableSequentialData)out, (FieldDefinition)TokenTransferListSchema.EXPECTED_DECIMALS, (Integer)data.expectedDecimals());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(TokenTransferList data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenTransferListSchema.TOKEN, (Object)data.token(), arg_0 -> TokenID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)TokenTransferListSchema.TRANSFERS, data.transfers(), arg_0 -> AccountAmount.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)TokenTransferListSchema.NFT_TRANSFERS, data.nftTransfers(), arg_0 -> NftTransfer.PROTOBUF.measureRecord(arg_0));
        return size += ProtoWriterTools.sizeOfOptionalInteger((FieldDefinition)TokenTransferListSchema.EXPECTED_DECIMALS, (Integer)data.expectedDecimals());
    }

    public boolean fastEquals(@NonNull TokenTransferList item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private TokenTransferList parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Record temp_token = null;
        List temp_transfers = Collections.emptyList();
        List temp_nftTransfers = Collections.emptyList();
        Integer temp_expected_decimals = null;
        try {
            block8: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = TokenTransferListSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (TokenID)TokenID.PROTOBUF.parseStrict(input) : (TokenID)TokenID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_token = value;
                        continue block8;
                    }
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountAmount)AccountAmount.PROTOBUF.parseStrict(input) : (AccountAmount)AccountAmount.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_transfers = ProtoParserTools.addToList(temp_transfers, (Object)value);
                        continue block8;
                    }
                    case 26: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (NftTransfer)NftTransfer.PROTOBUF.parseStrict(input) : (NftTransfer)NftTransfer.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_nftTransfers = ProtoParserTools.addToList(temp_nftTransfers, (Object)value);
                        continue block8;
                    }
                    case 34: {
                        Integer value;
                        int valueTypeMessageSize = input.readVarInt(false);
                        if (valueTypeMessageSize > 0) {
                            long beforeLimit = input.limit();
                            input.limit(input.position() + (long)valueTypeMessageSize);
                            int valueFieldTag = input.readVarInt(false);
                            assert (valueFieldTag >>> 3 == 1);
                            assert ((valueFieldTag & 7) == 0);
                            value = ProtoParserTools.readUint32((ReadableSequentialData)input);
                            input.limit(beforeLimit);
                        } else {
                            value = 0;
                        }
                        temp_expected_decimals = value;
                        continue block8;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new TokenTransferList((TokenID)temp_token, temp_transfers, temp_nftTransfers, temp_expected_decimals);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new TokenTransferList((TokenID)temp_token, temp_transfers, temp_nftTransfers, temp_expected_decimals);
    }
}

