/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.SignatureList;
import com.hedera.hapi.node.base.SignatureMap;
import com.hedera.hapi.node.base.Transaction;
import com.hedera.hapi.node.base.schema.TransactionSchema;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class TransactionProtoCodec
implements Codec<Transaction> {
    @NonNull
    public Transaction parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public Transaction parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull Transaction data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionSchema.BODY, (Object)data.body(), (arg_0, arg_1) -> TransactionBody.PROTOBUF.write(arg_0, arg_1), arg_0 -> TransactionBody.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionSchema.SIGS, (Object)data.sigs(), (arg_0, arg_1) -> SignatureList.PROTOBUF.write(arg_0, arg_1), arg_0 -> SignatureList.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionSchema.SIG_MAP, (Object)data.sigMap(), (arg_0, arg_1) -> SignatureMap.PROTOBUF.write(arg_0, arg_1), arg_0 -> SignatureMap.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)TransactionSchema.BODY_BYTES, (RandomAccessData)data.bodyBytes());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)TransactionSchema.SIGNED_TRANSACTION_BYTES, (RandomAccessData)data.signedTransactionBytes());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(Transaction data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionSchema.BODY, (Object)data.body(), arg_0 -> TransactionBody.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionSchema.SIGS, (Object)data.sigs(), arg_0 -> SignatureList.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionSchema.SIG_MAP, (Object)data.sigMap(), arg_0 -> SignatureMap.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)TransactionSchema.BODY_BYTES, (RandomAccessData)data.bodyBytes());
        return size += ProtoWriterTools.sizeOfBytes((FieldDefinition)TransactionSchema.SIGNED_TRANSACTION_BYTES, (RandomAccessData)data.signedTransactionBytes());
    }

    public boolean fastEquals(@NonNull Transaction item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private Transaction parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Record temp_body = null;
        Record temp_sigs = null;
        Record temp_sigMap = null;
        Bytes temp_bodyBytes = Bytes.EMPTY;
        Bytes temp_signedTransactionBytes = Bytes.EMPTY;
        try {
            block9: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = TransactionSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (TransactionBody)TransactionBody.PROTOBUF.parseStrict(input) : (TransactionBody)TransactionBody.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_body = value;
                        continue block9;
                    }
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (SignatureList)SignatureList.PROTOBUF.parseStrict(input) : (SignatureList)SignatureList.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_sigs = value;
                        continue block9;
                    }
                    case 26: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (SignatureMap)SignatureMap.PROTOBUF.parseStrict(input) : (SignatureMap)SignatureMap.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_sigMap = value;
                        continue block9;
                    }
                    case 34: {
                        Bytes value;
                        temp_bodyBytes = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block9;
                    }
                    case 42: {
                        Bytes value;
                        temp_signedTransactionBytes = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block9;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new Transaction((TransactionBody)temp_body, (SignatureList)temp_sigs, (SignatureMap)temp_sigMap, temp_bodyBytes, temp_signedTransactionBytes);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new Transaction((TransactionBody)temp_body, (SignatureList)temp_sigs, (SignatureMap)temp_sigMap, temp_bodyBytes, temp_signedTransactionBytes);
    }
}

