/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.base.schema.TransferListSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class TransferListProtoCodec
implements Codec<TransferList> {
    @NonNull
    public TransferList parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public TransferList parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull TransferList data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)TransferListSchema.ACCOUNT_AMOUNTS, data.accountAmounts(), (arg_0, arg_1) -> AccountAmount.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountAmount.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(TransferList data) {
        int size = 0;
        return size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)TransferListSchema.ACCOUNT_AMOUNTS, data.accountAmounts(), arg_0 -> AccountAmount.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull TransferList item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private TransferList parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        List temp_accountAmounts = Collections.emptyList();
        try {
            block5: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = TransferListSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        AccountAmount value = strictMode ? (AccountAmount)AccountAmount.PROTOBUF.parseStrict(input) : (AccountAmount)AccountAmount.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_accountAmounts = ProtoParserTools.addToList(temp_accountAmounts, (Object)value);
                        continue block5;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new TransferList(temp_accountAmounts);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new TransferList(temp_accountAmounts);
    }
}

