/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.consensus;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.consensus.codec.ConsensusTopicInfoJsonCodec;
import com.hedera.hapi.node.consensus.codec.ConsensusTopicInfoProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record ConsensusTopicInfo(String memo, Bytes runningHash, long sequenceNumber, @Nullable Timestamp expirationTime, @Nullable Key adminKey, @Nullable Key submitKey, @Nullable Duration autoRenewPeriod, @Nullable AccountID autoRenewAccount, Bytes ledgerId) {
    public static final Codec<ConsensusTopicInfo> PROTOBUF = new ConsensusTopicInfoProtoCodec();
    public static final JsonCodec<ConsensusTopicInfo> JSON = new ConsensusTopicInfoJsonCodec();
    public static final ConsensusTopicInfo DEFAULT = ConsensusTopicInfo.newBuilder().build();

    public boolean hasExpirationTime() {
        return this.expirationTime != null;
    }

    public Timestamp expirationTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasExpirationTime() ? this.expirationTime : defaultValue;
    }

    @NonNull
    public Timestamp expirationTimeOrThrow() {
        return Objects.requireNonNull(this.expirationTime, "Field expirationTime is null");
    }

    public void ifExpirationTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasExpirationTime()) {
            ifPresent.accept(this.expirationTime);
        }
    }

    public boolean hasAdminKey() {
        return this.adminKey != null;
    }

    public Key adminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasAdminKey() ? this.adminKey : defaultValue;
    }

    @NonNull
    public Key adminKeyOrThrow() {
        return Objects.requireNonNull(this.adminKey, "Field adminKey is null");
    }

    public void ifAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasAdminKey()) {
            ifPresent.accept(this.adminKey);
        }
    }

    public boolean hasSubmitKey() {
        return this.submitKey != null;
    }

    public Key submitKeyOrElse(@NonNull Key defaultValue) {
        return this.hasSubmitKey() ? this.submitKey : defaultValue;
    }

    @NonNull
    public Key submitKeyOrThrow() {
        return Objects.requireNonNull(this.submitKey, "Field submitKey is null");
    }

    public void ifSubmitKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasSubmitKey()) {
            ifPresent.accept(this.submitKey);
        }
    }

    public boolean hasAutoRenewPeriod() {
        return this.autoRenewPeriod != null;
    }

    public Duration autoRenewPeriodOrElse(@NonNull Duration defaultValue) {
        return this.hasAutoRenewPeriod() ? this.autoRenewPeriod : defaultValue;
    }

    @NonNull
    public Duration autoRenewPeriodOrThrow() {
        return Objects.requireNonNull(this.autoRenewPeriod, "Field autoRenewPeriod is null");
    }

    public void ifAutoRenewPeriod(@NonNull Consumer<Duration> ifPresent) {
        if (this.hasAutoRenewPeriod()) {
            ifPresent.accept(this.autoRenewPeriod);
        }
    }

    public boolean hasAutoRenewAccount() {
        return this.autoRenewAccount != null;
    }

    public AccountID autoRenewAccountOrElse(@NonNull AccountID defaultValue) {
        return this.hasAutoRenewAccount() ? this.autoRenewAccount : defaultValue;
    }

    @NonNull
    public AccountID autoRenewAccountOrThrow() {
        return Objects.requireNonNull(this.autoRenewAccount, "Field autoRenewAccount is null");
    }

    public void ifAutoRenewAccount(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAutoRenewAccount()) {
            ifPresent.accept(this.autoRenewAccount);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.memo, this.runningHash, this.sequenceNumber, this.expirationTime, this.adminKey, this.submitKey, this.autoRenewPeriod, this.autoRenewAccount, this.ledgerId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String memo = "";
        private Bytes runningHash = Bytes.EMPTY;
        private long sequenceNumber = 0L;
        private Timestamp expirationTime = null;
        private Key adminKey = null;
        private Key submitKey = null;
        private Duration autoRenewPeriod = null;
        private AccountID autoRenewAccount = null;
        private Bytes ledgerId = Bytes.EMPTY;

        public Builder() {
        }

        public Builder(String memo, Bytes runningHash, long sequenceNumber, Timestamp expirationTime, Key adminKey, Key submitKey, Duration autoRenewPeriod, AccountID autoRenewAccount, Bytes ledgerId) {
            this.memo = memo;
            this.runningHash = runningHash;
            this.sequenceNumber = sequenceNumber;
            this.expirationTime = expirationTime;
            this.adminKey = adminKey;
            this.submitKey = submitKey;
            this.autoRenewPeriod = autoRenewPeriod;
            this.autoRenewAccount = autoRenewAccount;
            this.ledgerId = ledgerId;
        }

        public ConsensusTopicInfo build() {
            return new ConsensusTopicInfo(this.memo, this.runningHash, this.sequenceNumber, this.expirationTime, this.adminKey, this.submitKey, this.autoRenewPeriod, this.autoRenewAccount, this.ledgerId);
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder runningHash(Bytes runningHash) {
            this.runningHash = runningHash;
            return this;
        }

        public Builder sequenceNumber(long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public Builder expirationTime(Timestamp expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public Builder expirationTime(Timestamp.Builder builder) {
            this.expirationTime = builder.build();
            return this;
        }

        public Builder adminKey(Key adminKey) {
            this.adminKey = adminKey;
            return this;
        }

        public Builder adminKey(Key.Builder builder) {
            this.adminKey = builder.build();
            return this;
        }

        public Builder submitKey(Key submitKey) {
            this.submitKey = submitKey;
            return this;
        }

        public Builder submitKey(Key.Builder builder) {
            this.submitKey = builder.build();
            return this;
        }

        public Builder autoRenewPeriod(Duration autoRenewPeriod) {
            this.autoRenewPeriod = autoRenewPeriod;
            return this;
        }

        public Builder autoRenewPeriod(Duration.Builder builder) {
            this.autoRenewPeriod = builder.build();
            return this;
        }

        public Builder autoRenewAccount(AccountID autoRenewAccount) {
            this.autoRenewAccount = autoRenewAccount;
            return this;
        }

        public Builder autoRenewAccount(AccountID.Builder builder) {
            this.autoRenewAccount = builder.build();
            return this;
        }

        public Builder ledgerId(Bytes ledgerId) {
            this.ledgerId = ledgerId;
            return this;
        }
    }
}

