/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.consensus.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.consensus.ConsensusTopicInfo;
import com.hedera.hapi.node.consensus.schema.ConsensusTopicInfoSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class ConsensusTopicInfoProtoCodec
implements Codec<ConsensusTopicInfo> {
    @NonNull
    public ConsensusTopicInfo parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public ConsensusTopicInfo parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull ConsensusTopicInfo data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)ConsensusTopicInfoSchema.MEMO, (String)data.memo());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)ConsensusTopicInfoSchema.RUNNING_HASH, (RandomAccessData)data.runningHash());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ConsensusTopicInfoSchema.SEQUENCE_NUMBER, (long)data.sequenceNumber());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ConsensusTopicInfoSchema.EXPIRATION_TIME, (Object)data.expirationTime(), (arg_0, arg_1) -> Timestamp.PROTOBUF.write(arg_0, arg_1), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ConsensusTopicInfoSchema.ADMIN_KEY, (Object)data.adminKey(), (arg_0, arg_1) -> Key.PROTOBUF.write(arg_0, arg_1), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ConsensusTopicInfoSchema.SUBMIT_KEY, (Object)data.submitKey(), (arg_0, arg_1) -> Key.PROTOBUF.write(arg_0, arg_1), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ConsensusTopicInfoSchema.AUTO_RENEW_PERIOD, (Object)data.autoRenewPeriod(), (arg_0, arg_1) -> Duration.PROTOBUF.write(arg_0, arg_1), arg_0 -> Duration.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ConsensusTopicInfoSchema.AUTO_RENEW_ACCOUNT, (Object)data.autoRenewAccount(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)ConsensusTopicInfoSchema.LEDGER_ID, (RandomAccessData)data.ledgerId());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(ConsensusTopicInfo data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfString((FieldDefinition)ConsensusTopicInfoSchema.MEMO, (String)data.memo());
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ConsensusTopicInfoSchema.RUNNING_HASH, (RandomAccessData)data.runningHash());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)ConsensusTopicInfoSchema.SEQUENCE_NUMBER, (long)data.sequenceNumber());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ConsensusTopicInfoSchema.EXPIRATION_TIME, (Object)data.expirationTime(), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ConsensusTopicInfoSchema.ADMIN_KEY, (Object)data.adminKey(), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ConsensusTopicInfoSchema.SUBMIT_KEY, (Object)data.submitKey(), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ConsensusTopicInfoSchema.AUTO_RENEW_PERIOD, (Object)data.autoRenewPeriod(), arg_0 -> Duration.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ConsensusTopicInfoSchema.AUTO_RENEW_ACCOUNT, (Object)data.autoRenewAccount(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        return size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ConsensusTopicInfoSchema.LEDGER_ID, (RandomAccessData)data.ledgerId());
    }

    public boolean fastEquals(@NonNull ConsensusTopicInfo item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private ConsensusTopicInfo parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        String temp_memo = "";
        Bytes temp_runningHash = Bytes.EMPTY;
        long temp_sequenceNumber = 0L;
        Record temp_expirationTime = null;
        Record temp_adminKey = null;
        Record temp_submitKey = null;
        Record temp_autoRenewPeriod = null;
        Record temp_autoRenewAccount = null;
        Bytes temp_ledger_id = Bytes.EMPTY;
        try {
            block13: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = ConsensusTopicInfoSchema.getField(field);
                switch (tag) {
                    case 10: {
                        String value;
                        temp_memo = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block13;
                    }
                    case 18: {
                        Bytes value;
                        temp_runningHash = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block13;
                    }
                    case 24: {
                        long value;
                        temp_sequenceNumber = value = ProtoParserTools.readUint64((ReadableSequentialData)input);
                        continue block13;
                    }
                    case 34: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Timestamp)Timestamp.PROTOBUF.parseStrict(input) : (Timestamp)Timestamp.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_expirationTime = value;
                        continue block13;
                    }
                    case 42: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Key)Key.PROTOBUF.parseStrict(input) : (Key)Key.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_adminKey = value;
                        continue block13;
                    }
                    case 50: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Key)Key.PROTOBUF.parseStrict(input) : (Key)Key.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_submitKey = value;
                        continue block13;
                    }
                    case 58: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Duration)Duration.PROTOBUF.parseStrict(input) : (Duration)Duration.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_autoRenewPeriod = value;
                        continue block13;
                    }
                    case 66: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_autoRenewAccount = value;
                        continue block13;
                    }
                    case 74: {
                        Bytes value;
                        temp_ledger_id = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block13;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new ConsensusTopicInfo(temp_memo, temp_runningHash, temp_sequenceNumber, (Timestamp)temp_expirationTime, (Key)temp_adminKey, (Key)temp_submitKey, (Duration)temp_autoRenewPeriod, (AccountID)temp_autoRenewAccount, temp_ledger_id);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new ConsensusTopicInfo(temp_memo, temp_runningHash, temp_sequenceNumber, (Timestamp)temp_expirationTime, (Key)temp_adminKey, (Key)temp_submitKey, (Duration)temp_autoRenewPeriod, (AccountID)temp_autoRenewAccount, temp_ledger_id);
    }
}

