/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.QueryHeader;
import com.hedera.hapi.node.contract.codec.ContractCallLocalQueryJsonCodec;
import com.hedera.hapi.node.contract.codec.ContractCallLocalQueryProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record ContractCallLocalQuery(@Nullable QueryHeader header, @Nullable ContractID contractID, long gas, Bytes functionParameters, long maxResultSize, @Nullable AccountID senderId) {
    public static final Codec<ContractCallLocalQuery> PROTOBUF = new ContractCallLocalQueryProtoCodec();
    public static final JsonCodec<ContractCallLocalQuery> JSON = new ContractCallLocalQueryJsonCodec();
    public static final ContractCallLocalQuery DEFAULT = ContractCallLocalQuery.newBuilder().build();

    public boolean hasHeader() {
        return this.header != null;
    }

    public QueryHeader headerOrElse(@NonNull QueryHeader defaultValue) {
        return this.hasHeader() ? this.header : defaultValue;
    }

    @NonNull
    public QueryHeader headerOrThrow() {
        return Objects.requireNonNull(this.header, "Field header is null");
    }

    public void ifHeader(@NonNull Consumer<QueryHeader> ifPresent) {
        if (this.hasHeader()) {
            ifPresent.accept(this.header);
        }
    }

    public boolean hasContractID() {
        return this.contractID != null;
    }

    public ContractID contractIDOrElse(@NonNull ContractID defaultValue) {
        return this.hasContractID() ? this.contractID : defaultValue;
    }

    @NonNull
    public ContractID contractIDOrThrow() {
        return Objects.requireNonNull(this.contractID, "Field contractID is null");
    }

    public void ifContractID(@NonNull Consumer<ContractID> ifPresent) {
        if (this.hasContractID()) {
            ifPresent.accept(this.contractID);
        }
    }

    public boolean hasSenderId() {
        return this.senderId != null;
    }

    public AccountID senderIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasSenderId() ? this.senderId : defaultValue;
    }

    @NonNull
    public AccountID senderIdOrThrow() {
        return Objects.requireNonNull(this.senderId, "Field senderId is null");
    }

    public void ifSenderId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasSenderId()) {
            ifPresent.accept(this.senderId);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.header, this.contractID, this.gas, this.functionParameters, this.maxResultSize, this.senderId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private QueryHeader header = null;
        private ContractID contractID = null;
        private long gas = 0L;
        private Bytes functionParameters = Bytes.EMPTY;
        private long maxResultSize = 0L;
        private AccountID senderId = null;

        public Builder() {
        }

        public Builder(QueryHeader header, ContractID contractID, long gas, Bytes functionParameters, long maxResultSize, AccountID senderId) {
            this.header = header;
            this.contractID = contractID;
            this.gas = gas;
            this.functionParameters = functionParameters;
            this.maxResultSize = maxResultSize;
            this.senderId = senderId;
        }

        public ContractCallLocalQuery build() {
            return new ContractCallLocalQuery(this.header, this.contractID, this.gas, this.functionParameters, this.maxResultSize, this.senderId);
        }

        public Builder header(QueryHeader header) {
            this.header = header;
            return this;
        }

        public Builder header(QueryHeader.Builder builder) {
            this.header = builder.build();
            return this;
        }

        public Builder contractID(ContractID contractID) {
            this.contractID = contractID;
            return this;
        }

        public Builder contractID(ContractID.Builder builder) {
            this.contractID = builder.build();
            return this;
        }

        public Builder gas(long gas) {
            this.gas = gas;
            return this;
        }

        public Builder functionParameters(Bytes functionParameters) {
            this.functionParameters = functionParameters;
            return this;
        }

        public Builder maxResultSize(long maxResultSize) {
            this.maxResultSize = maxResultSize;
            return this;
        }

        public Builder senderId(AccountID senderId) {
            this.senderId = senderId;
            return this;
        }

        public Builder senderId(AccountID.Builder builder) {
            this.senderId = builder.build();
            return this;
        }
    }
}

