/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.RealmID;
import com.hedera.hapi.node.base.ShardID;
import com.hedera.hapi.node.contract.codec.ContractCreateTransactionBodyJsonCodec;
import com.hedera.hapi.node.contract.codec.ContractCreateTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record ContractCreateTransactionBody(OneOf<InitcodeSourceOneOfType> initcodeSource, @Nullable Key adminKey, long gas, long initialBalance, @Nullable AccountID proxyAccountID, @Nullable Duration autoRenewPeriod, Bytes constructorParameters, @Nullable ShardID shardID, @Nullable RealmID realmID, @Nullable Key newRealmAdminKey, String memo, int maxAutomaticTokenAssociations, @Nullable AccountID autoRenewAccountId, OneOf<StakedIdOneOfType> stakedId, boolean declineReward) {
    public static final Codec<ContractCreateTransactionBody> PROTOBUF = new ContractCreateTransactionBodyProtoCodec();
    public static final JsonCodec<ContractCreateTransactionBody> JSON = new ContractCreateTransactionBodyJsonCodec();
    public static final ContractCreateTransactionBody DEFAULT = ContractCreateTransactionBody.newBuilder().build();

    public ContractCreateTransactionBody {
        if (initcodeSource == null) {
            throw new NullPointerException("Parameter 'initcodeSource' must be supplied and can not be null");
        }
        if (stakedId == null) {
            throw new NullPointerException("Parameter 'stakedId' must be supplied and can not be null");
        }
    }

    public boolean hasAdminKey() {
        return this.adminKey != null;
    }

    public Key adminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasAdminKey() ? this.adminKey : defaultValue;
    }

    @NonNull
    public Key adminKeyOrThrow() {
        return Objects.requireNonNull(this.adminKey, "Field adminKey is null");
    }

    public void ifAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasAdminKey()) {
            ifPresent.accept(this.adminKey);
        }
    }

    public boolean hasProxyAccountID() {
        return this.proxyAccountID != null;
    }

    public AccountID proxyAccountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasProxyAccountID() ? this.proxyAccountID : defaultValue;
    }

    @NonNull
    public AccountID proxyAccountIDOrThrow() {
        return Objects.requireNonNull(this.proxyAccountID, "Field proxyAccountID is null");
    }

    public void ifProxyAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasProxyAccountID()) {
            ifPresent.accept(this.proxyAccountID);
        }
    }

    public boolean hasAutoRenewPeriod() {
        return this.autoRenewPeriod != null;
    }

    public Duration autoRenewPeriodOrElse(@NonNull Duration defaultValue) {
        return this.hasAutoRenewPeriod() ? this.autoRenewPeriod : defaultValue;
    }

    @NonNull
    public Duration autoRenewPeriodOrThrow() {
        return Objects.requireNonNull(this.autoRenewPeriod, "Field autoRenewPeriod is null");
    }

    public void ifAutoRenewPeriod(@NonNull Consumer<Duration> ifPresent) {
        if (this.hasAutoRenewPeriod()) {
            ifPresent.accept(this.autoRenewPeriod);
        }
    }

    public boolean hasShardID() {
        return this.shardID != null;
    }

    public ShardID shardIDOrElse(@NonNull ShardID defaultValue) {
        return this.hasShardID() ? this.shardID : defaultValue;
    }

    @NonNull
    public ShardID shardIDOrThrow() {
        return Objects.requireNonNull(this.shardID, "Field shardID is null");
    }

    public void ifShardID(@NonNull Consumer<ShardID> ifPresent) {
        if (this.hasShardID()) {
            ifPresent.accept(this.shardID);
        }
    }

    public boolean hasRealmID() {
        return this.realmID != null;
    }

    public RealmID realmIDOrElse(@NonNull RealmID defaultValue) {
        return this.hasRealmID() ? this.realmID : defaultValue;
    }

    @NonNull
    public RealmID realmIDOrThrow() {
        return Objects.requireNonNull(this.realmID, "Field realmID is null");
    }

    public void ifRealmID(@NonNull Consumer<RealmID> ifPresent) {
        if (this.hasRealmID()) {
            ifPresent.accept(this.realmID);
        }
    }

    public boolean hasNewRealmAdminKey() {
        return this.newRealmAdminKey != null;
    }

    public Key newRealmAdminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasNewRealmAdminKey() ? this.newRealmAdminKey : defaultValue;
    }

    @NonNull
    public Key newRealmAdminKeyOrThrow() {
        return Objects.requireNonNull(this.newRealmAdminKey, "Field newRealmAdminKey is null");
    }

    public void ifNewRealmAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasNewRealmAdminKey()) {
            ifPresent.accept(this.newRealmAdminKey);
        }
    }

    public boolean hasAutoRenewAccountId() {
        return this.autoRenewAccountId != null;
    }

    public AccountID autoRenewAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasAutoRenewAccountId() ? this.autoRenewAccountId : defaultValue;
    }

    @NonNull
    public AccountID autoRenewAccountIdOrThrow() {
        return Objects.requireNonNull(this.autoRenewAccountId, "Field autoRenewAccountId is null");
    }

    public void ifAutoRenewAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAutoRenewAccountId()) {
            ifPresent.accept(this.autoRenewAccountId);
        }
    }

    @Nullable
    public FileID fileID() {
        return this.initcodeSource.kind() == InitcodeSourceOneOfType.FILE_ID ? (FileID)this.initcodeSource.value() : null;
    }

    public boolean hasFileID() {
        return this.initcodeSource.kind() == InitcodeSourceOneOfType.FILE_ID;
    }

    public FileID fileIDOrElse(@NonNull FileID defaultValue) {
        return this.hasFileID() ? this.fileID() : defaultValue;
    }

    @NonNull
    public FileID fileIDOrThrow() {
        return Objects.requireNonNull(this.fileID(), "Field fileID is null");
    }

    @Nullable
    public Bytes initcode() {
        return this.initcodeSource.kind() == InitcodeSourceOneOfType.INITCODE ? (Bytes)this.initcodeSource.value() : null;
    }

    public boolean hasInitcode() {
        return this.initcodeSource.kind() == InitcodeSourceOneOfType.INITCODE;
    }

    public Bytes initcodeOrElse(@NonNull Bytes defaultValue) {
        return this.hasInitcode() ? this.initcode() : defaultValue;
    }

    @NonNull
    public Bytes initcodeOrThrow() {
        return Objects.requireNonNull(this.initcode(), "Field initcode is null");
    }

    @Nullable
    public AccountID stakedAccountId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_ACCOUNT_ID ? (AccountID)this.stakedId.value() : null;
    }

    public boolean hasStakedAccountId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_ACCOUNT_ID;
    }

    public AccountID stakedAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasStakedAccountId() ? this.stakedAccountId() : defaultValue;
    }

    @NonNull
    public AccountID stakedAccountIdOrThrow() {
        return Objects.requireNonNull(this.stakedAccountId(), "Field stakedAccountId is null");
    }

    @Nullable
    public Long stakedNodeId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_NODE_ID ? (Long)this.stakedId.value() : null;
    }

    public boolean hasStakedNodeId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_NODE_ID;
    }

    public Long stakedNodeIdOrElse(@NonNull Long defaultValue) {
        return this.hasStakedNodeId() ? this.stakedNodeId() : defaultValue;
    }

    @NonNull
    public Long stakedNodeIdOrThrow() {
        return Objects.requireNonNull(this.stakedNodeId(), "Field stakedNodeId is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.initcodeSource, this.adminKey, this.gas, this.initialBalance, this.proxyAccountID, this.autoRenewPeriod, this.constructorParameters, this.shardID, this.realmID, this.newRealmAdminKey, this.memo, this.maxAutomaticTokenAssociations, this.autoRenewAccountId, this.stakedId, this.declineReward);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum InitcodeSourceOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        FILE_ID(1, "fileID"),
        INITCODE(16, "initcode");

        private final int protoOrdinal;
        private final String protoName;

        private InitcodeSourceOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static InitcodeSourceOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 16 -> INITCODE;
                case 1 -> FILE_ID;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static InitcodeSourceOneOfType fromString(String name) {
            return switch (name) {
                case "INITCODE", "initcode" -> INITCODE;
                case "FILE_ID", "fileID" -> FILE_ID;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static enum StakedIdOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        STAKED_ACCOUNT_ID(17, "staked_account_id"),
        STAKED_NODE_ID(18, "staked_node_id");

        private final int protoOrdinal;
        private final String protoName;

        private StakedIdOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static StakedIdOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 17 -> STAKED_ACCOUNT_ID;
                case 18 -> STAKED_NODE_ID;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static StakedIdOneOfType fromString(String name) {
            return switch (name) {
                case "STAKED_ACCOUNT_ID", "staked_account_id" -> STAKED_ACCOUNT_ID;
                case "STAKED_NODE_ID", "staked_node_id" -> STAKED_NODE_ID;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        private OneOf<InitcodeSourceOneOfType> initcodeSource = ContractCreateTransactionBodyProtoCodec.INITCODE_SOURCE_UNSET;
        private Key adminKey = null;
        private long gas = 0L;
        private long initialBalance = 0L;
        private AccountID proxyAccountID = null;
        private Duration autoRenewPeriod = null;
        private Bytes constructorParameters = Bytes.EMPTY;
        private ShardID shardID = null;
        private RealmID realmID = null;
        private Key newRealmAdminKey = null;
        private String memo = "";
        private int maxAutomaticTokenAssociations = 0;
        private AccountID autoRenewAccountId = null;
        private OneOf<StakedIdOneOfType> stakedId = ContractCreateTransactionBodyProtoCodec.STAKED_ID_UNSET;
        private boolean declineReward = false;

        public Builder() {
        }

        public Builder(OneOf<InitcodeSourceOneOfType> initcodeSource, Key adminKey, long gas, long initialBalance, AccountID proxyAccountID, Duration autoRenewPeriod, Bytes constructorParameters, ShardID shardID, RealmID realmID, Key newRealmAdminKey, String memo, int maxAutomaticTokenAssociations, AccountID autoRenewAccountId, OneOf<StakedIdOneOfType> stakedId, boolean declineReward) {
            this.initcodeSource = initcodeSource;
            this.adminKey = adminKey;
            this.gas = gas;
            this.initialBalance = initialBalance;
            this.proxyAccountID = proxyAccountID;
            this.autoRenewPeriod = autoRenewPeriod;
            this.constructorParameters = constructorParameters;
            this.shardID = shardID;
            this.realmID = realmID;
            this.newRealmAdminKey = newRealmAdminKey;
            this.memo = memo;
            this.maxAutomaticTokenAssociations = maxAutomaticTokenAssociations;
            this.autoRenewAccountId = autoRenewAccountId;
            this.stakedId = stakedId;
            this.declineReward = declineReward;
        }

        public ContractCreateTransactionBody build() {
            return new ContractCreateTransactionBody(this.initcodeSource, this.adminKey, this.gas, this.initialBalance, this.proxyAccountID, this.autoRenewPeriod, this.constructorParameters, this.shardID, this.realmID, this.newRealmAdminKey, this.memo, this.maxAutomaticTokenAssociations, this.autoRenewAccountId, this.stakedId, this.declineReward);
        }

        public Builder fileID(FileID fileID) {
            this.initcodeSource = new OneOf((Object)InitcodeSourceOneOfType.FILE_ID, (Object)fileID);
            return this;
        }

        public Builder fileID(FileID.Builder builder) {
            this.initcodeSource = new OneOf((Object)InitcodeSourceOneOfType.FILE_ID, (Object)builder.build());
            return this;
        }

        public Builder initcode(Bytes initcode) {
            this.initcodeSource = new OneOf((Object)InitcodeSourceOneOfType.INITCODE, (Object)initcode);
            return this;
        }

        public Builder adminKey(Key adminKey) {
            this.adminKey = adminKey;
            return this;
        }

        public Builder adminKey(Key.Builder builder) {
            this.adminKey = builder.build();
            return this;
        }

        public Builder gas(long gas) {
            this.gas = gas;
            return this;
        }

        public Builder initialBalance(long initialBalance) {
            this.initialBalance = initialBalance;
            return this;
        }

        public Builder proxyAccountID(AccountID proxyAccountID) {
            this.proxyAccountID = proxyAccountID;
            return this;
        }

        public Builder proxyAccountID(AccountID.Builder builder) {
            this.proxyAccountID = builder.build();
            return this;
        }

        public Builder autoRenewPeriod(Duration autoRenewPeriod) {
            this.autoRenewPeriod = autoRenewPeriod;
            return this;
        }

        public Builder autoRenewPeriod(Duration.Builder builder) {
            this.autoRenewPeriod = builder.build();
            return this;
        }

        public Builder constructorParameters(Bytes constructorParameters) {
            this.constructorParameters = constructorParameters;
            return this;
        }

        public Builder shardID(ShardID shardID) {
            this.shardID = shardID;
            return this;
        }

        public Builder shardID(ShardID.Builder builder) {
            this.shardID = builder.build();
            return this;
        }

        public Builder realmID(RealmID realmID) {
            this.realmID = realmID;
            return this;
        }

        public Builder realmID(RealmID.Builder builder) {
            this.realmID = builder.build();
            return this;
        }

        public Builder newRealmAdminKey(Key newRealmAdminKey) {
            this.newRealmAdminKey = newRealmAdminKey;
            return this;
        }

        public Builder newRealmAdminKey(Key.Builder builder) {
            this.newRealmAdminKey = builder.build();
            return this;
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder maxAutomaticTokenAssociations(int maxAutomaticTokenAssociations) {
            this.maxAutomaticTokenAssociations = maxAutomaticTokenAssociations;
            return this;
        }

        public Builder autoRenewAccountId(AccountID autoRenewAccountId) {
            this.autoRenewAccountId = autoRenewAccountId;
            return this;
        }

        public Builder autoRenewAccountId(AccountID.Builder builder) {
            this.autoRenewAccountId = builder.build();
            return this;
        }

        public Builder stakedAccountId(AccountID stakedAccountId) {
            this.stakedId = new OneOf((Object)StakedIdOneOfType.STAKED_ACCOUNT_ID, (Object)stakedAccountId);
            return this;
        }

        public Builder stakedAccountId(AccountID.Builder builder) {
            this.stakedId = new OneOf((Object)StakedIdOneOfType.STAKED_ACCOUNT_ID, (Object)builder.build());
            return this;
        }

        public Builder stakedNodeId(long stakedNodeId) {
            this.stakedId = new OneOf((Object)StakedIdOneOfType.STAKED_NODE_ID, (Object)stakedNodeId);
            return this;
        }

        public Builder declineReward(boolean declineReward) {
            this.declineReward = declineReward;
            return this;
        }
    }
}

