/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.contract.codec.ContractDeleteTransactionBodyJsonCodec;
import com.hedera.hapi.node.contract.codec.ContractDeleteTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record ContractDeleteTransactionBody(@Nullable ContractID contractID, OneOf<ObtainersOneOfType> obtainers, boolean permanentRemoval) {
    public static final Codec<ContractDeleteTransactionBody> PROTOBUF = new ContractDeleteTransactionBodyProtoCodec();
    public static final JsonCodec<ContractDeleteTransactionBody> JSON = new ContractDeleteTransactionBodyJsonCodec();
    public static final ContractDeleteTransactionBody DEFAULT = ContractDeleteTransactionBody.newBuilder().build();

    public ContractDeleteTransactionBody {
        if (obtainers == null) {
            throw new NullPointerException("Parameter 'obtainers' must be supplied and can not be null");
        }
    }

    public boolean hasContractID() {
        return this.contractID != null;
    }

    public ContractID contractIDOrElse(@NonNull ContractID defaultValue) {
        return this.hasContractID() ? this.contractID : defaultValue;
    }

    @NonNull
    public ContractID contractIDOrThrow() {
        return Objects.requireNonNull(this.contractID, "Field contractID is null");
    }

    public void ifContractID(@NonNull Consumer<ContractID> ifPresent) {
        if (this.hasContractID()) {
            ifPresent.accept(this.contractID);
        }
    }

    @Nullable
    public AccountID transferAccountID() {
        return this.obtainers.kind() == ObtainersOneOfType.TRANSFER_ACCOUNT_ID ? (AccountID)this.obtainers.value() : null;
    }

    public boolean hasTransferAccountID() {
        return this.obtainers.kind() == ObtainersOneOfType.TRANSFER_ACCOUNT_ID;
    }

    public AccountID transferAccountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasTransferAccountID() ? this.transferAccountID() : defaultValue;
    }

    @NonNull
    public AccountID transferAccountIDOrThrow() {
        return Objects.requireNonNull(this.transferAccountID(), "Field transferAccountID is null");
    }

    @Nullable
    public ContractID transferContractID() {
        return this.obtainers.kind() == ObtainersOneOfType.TRANSFER_CONTRACT_ID ? (ContractID)this.obtainers.value() : null;
    }

    public boolean hasTransferContractID() {
        return this.obtainers.kind() == ObtainersOneOfType.TRANSFER_CONTRACT_ID;
    }

    public ContractID transferContractIDOrElse(@NonNull ContractID defaultValue) {
        return this.hasTransferContractID() ? this.transferContractID() : defaultValue;
    }

    @NonNull
    public ContractID transferContractIDOrThrow() {
        return Objects.requireNonNull(this.transferContractID(), "Field transferContractID is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.contractID, this.obtainers, this.permanentRemoval);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum ObtainersOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        TRANSFER_ACCOUNT_ID(2, "transferAccountID"),
        TRANSFER_CONTRACT_ID(3, "transferContractID");

        private final int protoOrdinal;
        private final String protoName;

        private ObtainersOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static ObtainersOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 2 -> TRANSFER_ACCOUNT_ID;
                case 3 -> TRANSFER_CONTRACT_ID;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static ObtainersOneOfType fromString(String name) {
            return switch (name) {
                case "TRANSFER_ACCOUNT_ID", "transferAccountID" -> TRANSFER_ACCOUNT_ID;
                case "TRANSFER_CONTRACT_ID", "transferContractID" -> TRANSFER_CONTRACT_ID;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        private ContractID contractID = null;
        private OneOf<ObtainersOneOfType> obtainers = ContractDeleteTransactionBodyProtoCodec.OBTAINERS_UNSET;
        private boolean permanentRemoval = false;

        public Builder() {
        }

        public Builder(ContractID contractID, OneOf<ObtainersOneOfType> obtainers, boolean permanentRemoval) {
            this.contractID = contractID;
            this.obtainers = obtainers;
            this.permanentRemoval = permanentRemoval;
        }

        public ContractDeleteTransactionBody build() {
            return new ContractDeleteTransactionBody(this.contractID, this.obtainers, this.permanentRemoval);
        }

        public Builder contractID(ContractID contractID) {
            this.contractID = contractID;
            return this;
        }

        public Builder contractID(ContractID.Builder builder) {
            this.contractID = builder.build();
            return this;
        }

        public Builder transferAccountID(AccountID transferAccountID) {
            this.obtainers = new OneOf((Object)ObtainersOneOfType.TRANSFER_ACCOUNT_ID, (Object)transferAccountID);
            return this;
        }

        public Builder transferAccountID(AccountID.Builder builder) {
            this.obtainers = new OneOf((Object)ObtainersOneOfType.TRANSFER_ACCOUNT_ID, (Object)builder.build());
            return this;
        }

        public Builder transferContractID(ContractID transferContractID) {
            this.obtainers = new OneOf((Object)ObtainersOneOfType.TRANSFER_CONTRACT_ID, (Object)transferContractID);
            return this;
        }

        public Builder transferContractID(ContractID.Builder builder) {
            this.obtainers = new OneOf((Object)ObtainersOneOfType.TRANSFER_CONTRACT_ID, (Object)builder.build());
            return this;
        }

        public Builder permanentRemoval(boolean permanentRemoval) {
            this.permanentRemoval = permanentRemoval;
            return this;
        }
    }
}

