/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.contract.ContractLoginfo;
import com.hedera.hapi.node.contract.ContractNonceInfo;
import com.hedera.hapi.node.contract.codec.ContractFunctionResultJsonCodec;
import com.hedera.hapi.node.contract.codec.ContractFunctionResultProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record ContractFunctionResult(@Nullable ContractID contractID, Bytes contractCallResult, String errorMessage, Bytes bloom, long gasUsed, @Nullable List<ContractLoginfo> logInfo, @Nullable List<ContractID> createdContractIDs, @Nullable Bytes evmAddress, long gas, long amount, Bytes functionParameters, @Nullable AccountID senderId, @Nullable List<ContractNonceInfo> contractNonces) {
    public static final Codec<ContractFunctionResult> PROTOBUF = new ContractFunctionResultProtoCodec();
    public static final JsonCodec<ContractFunctionResult> JSON = new ContractFunctionResultJsonCodec();
    public static final ContractFunctionResult DEFAULT = ContractFunctionResult.newBuilder().build();

    public boolean hasContractID() {
        return this.contractID != null;
    }

    public ContractID contractIDOrElse(@NonNull ContractID defaultValue) {
        return this.hasContractID() ? this.contractID : defaultValue;
    }

    @NonNull
    public ContractID contractIDOrThrow() {
        return Objects.requireNonNull(this.contractID, "Field contractID is null");
    }

    public void ifContractID(@NonNull Consumer<ContractID> ifPresent) {
        if (this.hasContractID()) {
            ifPresent.accept(this.contractID);
        }
    }

    public boolean hasLogInfo() {
        return this.logInfo != null;
    }

    public List<ContractLoginfo> logInfoOrElse(@NonNull List<ContractLoginfo> defaultValue) {
        return this.hasLogInfo() ? this.logInfo : defaultValue;
    }

    @NonNull
    public List<ContractLoginfo> logInfoOrThrow() {
        return Objects.requireNonNull(this.logInfo, "Field logInfo is null");
    }

    public void ifLogInfo(@NonNull Consumer<List<ContractLoginfo>> ifPresent) {
        if (this.hasLogInfo()) {
            ifPresent.accept(this.logInfo);
        }
    }

    public boolean hasCreatedContractIDs() {
        return this.createdContractIDs != null;
    }

    public List<ContractID> createdContractIDsOrElse(@NonNull List<ContractID> defaultValue) {
        return this.hasCreatedContractIDs() ? this.createdContractIDs : defaultValue;
    }

    @NonNull
    public List<ContractID> createdContractIDsOrThrow() {
        return Objects.requireNonNull(this.createdContractIDs, "Field createdContractIDs is null");
    }

    public void ifCreatedContractIDs(@NonNull Consumer<List<ContractID>> ifPresent) {
        if (this.hasCreatedContractIDs()) {
            ifPresent.accept(this.createdContractIDs);
        }
    }

    public boolean hasEvmAddress() {
        return this.evmAddress != null;
    }

    public Bytes evmAddressOrElse(@NonNull Bytes defaultValue) {
        return this.hasEvmAddress() ? this.evmAddress : defaultValue;
    }

    @NonNull
    public Bytes evmAddressOrThrow() {
        return Objects.requireNonNull(this.evmAddress, "Field evmAddress is null");
    }

    public void ifEvmAddress(@NonNull Consumer<Bytes> ifPresent) {
        if (this.hasEvmAddress()) {
            ifPresent.accept(this.evmAddress);
        }
    }

    public boolean hasSenderId() {
        return this.senderId != null;
    }

    public AccountID senderIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasSenderId() ? this.senderId : defaultValue;
    }

    @NonNull
    public AccountID senderIdOrThrow() {
        return Objects.requireNonNull(this.senderId, "Field senderId is null");
    }

    public void ifSenderId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasSenderId()) {
            ifPresent.accept(this.senderId);
        }
    }

    public boolean hasContractNonces() {
        return this.contractNonces != null;
    }

    public List<ContractNonceInfo> contractNoncesOrElse(@NonNull List<ContractNonceInfo> defaultValue) {
        return this.hasContractNonces() ? this.contractNonces : defaultValue;
    }

    @NonNull
    public List<ContractNonceInfo> contractNoncesOrThrow() {
        return Objects.requireNonNull(this.contractNonces, "Field contractNonces is null");
    }

    public void ifContractNonces(@NonNull Consumer<List<ContractNonceInfo>> ifPresent) {
        if (this.hasContractNonces()) {
            ifPresent.accept(this.contractNonces);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.contractID, this.contractCallResult, this.errorMessage, this.bloom, this.gasUsed, this.logInfo, this.createdContractIDs, this.evmAddress, this.gas, this.amount, this.functionParameters, this.senderId, this.contractNonces);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private ContractID contractID = null;
        private Bytes contractCallResult = Bytes.EMPTY;
        private String errorMessage = "";
        private Bytes bloom = Bytes.EMPTY;
        private long gasUsed = 0L;
        private List<ContractLoginfo> logInfo = Collections.emptyList();
        private List<ContractID> createdContractIDs = Collections.emptyList();
        private Bytes evmAddress = null;
        private long gas = 0L;
        private long amount = 0L;
        private Bytes functionParameters = Bytes.EMPTY;
        private AccountID senderId = null;
        private List<ContractNonceInfo> contractNonces = Collections.emptyList();

        public Builder() {
        }

        public Builder(ContractID contractID, Bytes contractCallResult, String errorMessage, Bytes bloom, long gasUsed, List<ContractLoginfo> logInfo, List<ContractID> createdContractIDs, Bytes evmAddress, long gas, long amount, Bytes functionParameters, AccountID senderId, List<ContractNonceInfo> contractNonces) {
            this.contractID = contractID;
            this.contractCallResult = contractCallResult;
            this.errorMessage = errorMessage;
            this.bloom = bloom;
            this.gasUsed = gasUsed;
            this.logInfo = logInfo;
            this.createdContractIDs = createdContractIDs;
            this.evmAddress = evmAddress;
            this.gas = gas;
            this.amount = amount;
            this.functionParameters = functionParameters;
            this.senderId = senderId;
            this.contractNonces = contractNonces;
        }

        public ContractFunctionResult build() {
            return new ContractFunctionResult(this.contractID, this.contractCallResult, this.errorMessage, this.bloom, this.gasUsed, this.logInfo, this.createdContractIDs, this.evmAddress, this.gas, this.amount, this.functionParameters, this.senderId, this.contractNonces);
        }

        public Builder contractID(ContractID contractID) {
            this.contractID = contractID;
            return this;
        }

        public Builder contractID(ContractID.Builder builder) {
            this.contractID = builder.build();
            return this;
        }

        public Builder contractCallResult(Bytes contractCallResult) {
            this.contractCallResult = contractCallResult;
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public Builder bloom(Bytes bloom) {
            this.bloom = bloom;
            return this;
        }

        public Builder gasUsed(long gasUsed) {
            this.gasUsed = gasUsed;
            return this;
        }

        public Builder logInfo(List<ContractLoginfo> logInfo) {
            this.logInfo = logInfo;
            return this;
        }

        public Builder logInfo(ContractLoginfo ... values) {
            this.logInfo = List.of(values);
            return this;
        }

        public Builder createdContractIDs(List<ContractID> createdContractIDs) {
            this.createdContractIDs = createdContractIDs;
            return this;
        }

        public Builder createdContractIDs(ContractID ... values) {
            this.createdContractIDs = List.of(values);
            return this;
        }

        public Builder evmAddress(Bytes evmAddress) {
            this.evmAddress = evmAddress;
            return this;
        }

        public Builder gas(long gas) {
            this.gas = gas;
            return this;
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public Builder functionParameters(Bytes functionParameters) {
            this.functionParameters = functionParameters;
            return this;
        }

        public Builder senderId(AccountID senderId) {
            this.senderId = senderId;
            return this;
        }

        public Builder senderId(AccountID.Builder builder) {
            this.senderId = builder.build();
            return this;
        }

        public Builder contractNonces(List<ContractNonceInfo> contractNonces) {
            this.contractNonces = contractNonces;
            return this;
        }

        public Builder contractNonces(ContractNonceInfo ... values) {
            this.contractNonces = List.of(values);
            return this;
        }
    }
}

