/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.contract.codec.ContractUpdateTransactionBodyJsonCodec;
import com.hedera.hapi.node.contract.codec.ContractUpdateTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record ContractUpdateTransactionBody(@Nullable ContractID contractID, @Nullable Timestamp expirationTime, @Nullable Key adminKey, @Nullable AccountID proxyAccountID, @Nullable Duration autoRenewPeriod, @Nullable FileID fileID, OneOf<MemoFieldOneOfType> memoField, @Nullable Integer maxAutomaticTokenAssociations, @Nullable AccountID autoRenewAccountId, OneOf<StakedIdOneOfType> stakedId, @Nullable Boolean declineReward) {
    public static final Codec<ContractUpdateTransactionBody> PROTOBUF = new ContractUpdateTransactionBodyProtoCodec();
    public static final JsonCodec<ContractUpdateTransactionBody> JSON = new ContractUpdateTransactionBodyJsonCodec();
    public static final ContractUpdateTransactionBody DEFAULT = ContractUpdateTransactionBody.newBuilder().build();

    public ContractUpdateTransactionBody {
        if (memoField == null) {
            throw new NullPointerException("Parameter 'memoField' must be supplied and can not be null");
        }
        if (memoField.kind() == MemoFieldOneOfType.MEMO_WRAPPER && memoField.value() == null) {
            memoField = new OneOf((Object)MemoFieldOneOfType.UNSET, null);
        }
        if (stakedId == null) {
            throw new NullPointerException("Parameter 'stakedId' must be supplied and can not be null");
        }
    }

    public boolean hasContractID() {
        return this.contractID != null;
    }

    public ContractID contractIDOrElse(@NonNull ContractID defaultValue) {
        return this.hasContractID() ? this.contractID : defaultValue;
    }

    @NonNull
    public ContractID contractIDOrThrow() {
        return Objects.requireNonNull(this.contractID, "Field contractID is null");
    }

    public void ifContractID(@NonNull Consumer<ContractID> ifPresent) {
        if (this.hasContractID()) {
            ifPresent.accept(this.contractID);
        }
    }

    public boolean hasExpirationTime() {
        return this.expirationTime != null;
    }

    public Timestamp expirationTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasExpirationTime() ? this.expirationTime : defaultValue;
    }

    @NonNull
    public Timestamp expirationTimeOrThrow() {
        return Objects.requireNonNull(this.expirationTime, "Field expirationTime is null");
    }

    public void ifExpirationTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasExpirationTime()) {
            ifPresent.accept(this.expirationTime);
        }
    }

    public boolean hasAdminKey() {
        return this.adminKey != null;
    }

    public Key adminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasAdminKey() ? this.adminKey : defaultValue;
    }

    @NonNull
    public Key adminKeyOrThrow() {
        return Objects.requireNonNull(this.adminKey, "Field adminKey is null");
    }

    public void ifAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasAdminKey()) {
            ifPresent.accept(this.adminKey);
        }
    }

    public boolean hasProxyAccountID() {
        return this.proxyAccountID != null;
    }

    public AccountID proxyAccountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasProxyAccountID() ? this.proxyAccountID : defaultValue;
    }

    @NonNull
    public AccountID proxyAccountIDOrThrow() {
        return Objects.requireNonNull(this.proxyAccountID, "Field proxyAccountID is null");
    }

    public void ifProxyAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasProxyAccountID()) {
            ifPresent.accept(this.proxyAccountID);
        }
    }

    public boolean hasAutoRenewPeriod() {
        return this.autoRenewPeriod != null;
    }

    public Duration autoRenewPeriodOrElse(@NonNull Duration defaultValue) {
        return this.hasAutoRenewPeriod() ? this.autoRenewPeriod : defaultValue;
    }

    @NonNull
    public Duration autoRenewPeriodOrThrow() {
        return Objects.requireNonNull(this.autoRenewPeriod, "Field autoRenewPeriod is null");
    }

    public void ifAutoRenewPeriod(@NonNull Consumer<Duration> ifPresent) {
        if (this.hasAutoRenewPeriod()) {
            ifPresent.accept(this.autoRenewPeriod);
        }
    }

    public boolean hasFileID() {
        return this.fileID != null;
    }

    public FileID fileIDOrElse(@NonNull FileID defaultValue) {
        return this.hasFileID() ? this.fileID : defaultValue;
    }

    @NonNull
    public FileID fileIDOrThrow() {
        return Objects.requireNonNull(this.fileID, "Field fileID is null");
    }

    public void ifFileID(@NonNull Consumer<FileID> ifPresent) {
        if (this.hasFileID()) {
            ifPresent.accept(this.fileID);
        }
    }

    public boolean hasMaxAutomaticTokenAssociations() {
        return this.maxAutomaticTokenAssociations != null;
    }

    public Integer maxAutomaticTokenAssociationsOrElse(@NonNull Integer defaultValue) {
        return this.hasMaxAutomaticTokenAssociations() ? this.maxAutomaticTokenAssociations : defaultValue;
    }

    @NonNull
    public Integer maxAutomaticTokenAssociationsOrThrow() {
        return Objects.requireNonNull(this.maxAutomaticTokenAssociations, "Field maxAutomaticTokenAssociations is null");
    }

    public void ifMaxAutomaticTokenAssociations(@NonNull Consumer<Integer> ifPresent) {
        if (this.hasMaxAutomaticTokenAssociations()) {
            ifPresent.accept(this.maxAutomaticTokenAssociations);
        }
    }

    public boolean hasAutoRenewAccountId() {
        return this.autoRenewAccountId != null;
    }

    public AccountID autoRenewAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasAutoRenewAccountId() ? this.autoRenewAccountId : defaultValue;
    }

    @NonNull
    public AccountID autoRenewAccountIdOrThrow() {
        return Objects.requireNonNull(this.autoRenewAccountId, "Field autoRenewAccountId is null");
    }

    public void ifAutoRenewAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAutoRenewAccountId()) {
            ifPresent.accept(this.autoRenewAccountId);
        }
    }

    public boolean hasDeclineReward() {
        return this.declineReward != null;
    }

    public Boolean declineRewardOrElse(@NonNull Boolean defaultValue) {
        return this.hasDeclineReward() ? this.declineReward : defaultValue;
    }

    @NonNull
    public Boolean declineRewardOrThrow() {
        return Objects.requireNonNull(this.declineReward, "Field declineReward is null");
    }

    public void ifDeclineReward(@NonNull Consumer<Boolean> ifPresent) {
        if (this.hasDeclineReward()) {
            ifPresent.accept(this.declineReward);
        }
    }

    @Nullable
    public String memo() {
        return this.memoField.kind() == MemoFieldOneOfType.MEMO ? (String)this.memoField.value() : null;
    }

    public boolean hasMemo() {
        return this.memoField.kind() == MemoFieldOneOfType.MEMO;
    }

    public String memoOrElse(@NonNull String defaultValue) {
        return this.hasMemo() ? this.memo() : defaultValue;
    }

    @NonNull
    public String memoOrThrow() {
        return Objects.requireNonNull(this.memo(), "Field memo is null");
    }

    @Nullable
    public String memoWrapper() {
        return this.memoField.kind() == MemoFieldOneOfType.MEMO_WRAPPER ? (String)this.memoField.value() : null;
    }

    public boolean hasMemoWrapper() {
        return this.memoField.kind() == MemoFieldOneOfType.MEMO_WRAPPER;
    }

    public String memoWrapperOrElse(@NonNull String defaultValue) {
        return this.hasMemoWrapper() ? this.memoWrapper() : defaultValue;
    }

    @NonNull
    public String memoWrapperOrThrow() {
        return Objects.requireNonNull(this.memoWrapper(), "Field memoWrapper is null");
    }

    @Nullable
    public AccountID stakedAccountId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_ACCOUNT_ID ? (AccountID)this.stakedId.value() : null;
    }

    public boolean hasStakedAccountId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_ACCOUNT_ID;
    }

    public AccountID stakedAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasStakedAccountId() ? this.stakedAccountId() : defaultValue;
    }

    @NonNull
    public AccountID stakedAccountIdOrThrow() {
        return Objects.requireNonNull(this.stakedAccountId(), "Field stakedAccountId is null");
    }

    @Nullable
    public Long stakedNodeId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_NODE_ID ? (Long)this.stakedId.value() : null;
    }

    public boolean hasStakedNodeId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_NODE_ID;
    }

    public Long stakedNodeIdOrElse(@NonNull Long defaultValue) {
        return this.hasStakedNodeId() ? this.stakedNodeId() : defaultValue;
    }

    @NonNull
    public Long stakedNodeIdOrThrow() {
        return Objects.requireNonNull(this.stakedNodeId(), "Field stakedNodeId is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.contractID, this.expirationTime, this.adminKey, this.proxyAccountID, this.autoRenewPeriod, this.fileID, this.memoField, this.maxAutomaticTokenAssociations, this.autoRenewAccountId, this.stakedId, this.declineReward);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum MemoFieldOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        MEMO(9, "memo"),
        MEMO_WRAPPER(10, "memoWrapper");

        private final int protoOrdinal;
        private final String protoName;

        private MemoFieldOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static MemoFieldOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 9 -> MEMO;
                case 10 -> MEMO_WRAPPER;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static MemoFieldOneOfType fromString(String name) {
            return switch (name) {
                case "MEMO", "memo" -> MEMO;
                case "MEMO_WRAPPER", "memoWrapper" -> MEMO_WRAPPER;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static enum StakedIdOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        STAKED_ACCOUNT_ID(13, "staked_account_id"),
        STAKED_NODE_ID(14, "staked_node_id");

        private final int protoOrdinal;
        private final String protoName;

        private StakedIdOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static StakedIdOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 13 -> STAKED_ACCOUNT_ID;
                case 14 -> STAKED_NODE_ID;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static StakedIdOneOfType fromString(String name) {
            return switch (name) {
                case "STAKED_ACCOUNT_ID", "staked_account_id" -> STAKED_ACCOUNT_ID;
                case "STAKED_NODE_ID", "staked_node_id" -> STAKED_NODE_ID;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        private ContractID contractID = null;
        private Timestamp expirationTime = null;
        private Key adminKey = null;
        private AccountID proxyAccountID = null;
        private Duration autoRenewPeriod = null;
        private FileID fileID = null;
        private OneOf<MemoFieldOneOfType> memoField = ContractUpdateTransactionBodyProtoCodec.MEMO_FIELD_UNSET;
        private Integer maxAutomaticTokenAssociations = null;
        private AccountID autoRenewAccountId = null;
        private OneOf<StakedIdOneOfType> stakedId = ContractUpdateTransactionBodyProtoCodec.STAKED_ID_UNSET;
        private Boolean declineReward = null;

        public Builder() {
        }

        public Builder(ContractID contractID, Timestamp expirationTime, Key adminKey, AccountID proxyAccountID, Duration autoRenewPeriod, FileID fileID, OneOf<MemoFieldOneOfType> memoField, Integer maxAutomaticTokenAssociations, AccountID autoRenewAccountId, OneOf<StakedIdOneOfType> stakedId, Boolean declineReward) {
            this.contractID = contractID;
            this.expirationTime = expirationTime;
            this.adminKey = adminKey;
            this.proxyAccountID = proxyAccountID;
            this.autoRenewPeriod = autoRenewPeriod;
            this.fileID = fileID;
            this.memoField = memoField;
            this.maxAutomaticTokenAssociations = maxAutomaticTokenAssociations;
            this.autoRenewAccountId = autoRenewAccountId;
            this.stakedId = stakedId;
            this.declineReward = declineReward;
        }

        public ContractUpdateTransactionBody build() {
            return new ContractUpdateTransactionBody(this.contractID, this.expirationTime, this.adminKey, this.proxyAccountID, this.autoRenewPeriod, this.fileID, this.memoField, this.maxAutomaticTokenAssociations, this.autoRenewAccountId, this.stakedId, this.declineReward);
        }

        public Builder contractID(ContractID contractID) {
            this.contractID = contractID;
            return this;
        }

        public Builder contractID(ContractID.Builder builder) {
            this.contractID = builder.build();
            return this;
        }

        public Builder expirationTime(Timestamp expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public Builder expirationTime(Timestamp.Builder builder) {
            this.expirationTime = builder.build();
            return this;
        }

        public Builder adminKey(Key adminKey) {
            this.adminKey = adminKey;
            return this;
        }

        public Builder adminKey(Key.Builder builder) {
            this.adminKey = builder.build();
            return this;
        }

        public Builder proxyAccountID(AccountID proxyAccountID) {
            this.proxyAccountID = proxyAccountID;
            return this;
        }

        public Builder proxyAccountID(AccountID.Builder builder) {
            this.proxyAccountID = builder.build();
            return this;
        }

        public Builder autoRenewPeriod(Duration autoRenewPeriod) {
            this.autoRenewPeriod = autoRenewPeriod;
            return this;
        }

        public Builder autoRenewPeriod(Duration.Builder builder) {
            this.autoRenewPeriod = builder.build();
            return this;
        }

        public Builder fileID(FileID fileID) {
            this.fileID = fileID;
            return this;
        }

        public Builder fileID(FileID.Builder builder) {
            this.fileID = builder.build();
            return this;
        }

        public Builder memo(String memo) {
            this.memoField = new OneOf((Object)MemoFieldOneOfType.MEMO, (Object)memo);
            return this;
        }

        public Builder memoWrapper(String memoWrapper) {
            this.memoField = new OneOf((Object)MemoFieldOneOfType.MEMO_WRAPPER, (Object)memoWrapper);
            return this;
        }

        public Builder maxAutomaticTokenAssociations(Integer maxAutomaticTokenAssociations) {
            this.maxAutomaticTokenAssociations = maxAutomaticTokenAssociations;
            return this;
        }

        public Builder autoRenewAccountId(AccountID autoRenewAccountId) {
            this.autoRenewAccountId = autoRenewAccountId;
            return this;
        }

        public Builder autoRenewAccountId(AccountID.Builder builder) {
            this.autoRenewAccountId = builder.build();
            return this;
        }

        public Builder stakedAccountId(AccountID stakedAccountId) {
            this.stakedId = new OneOf((Object)StakedIdOneOfType.STAKED_ACCOUNT_ID, (Object)stakedAccountId);
            return this;
        }

        public Builder stakedAccountId(AccountID.Builder builder) {
            this.stakedId = new OneOf((Object)StakedIdOneOfType.STAKED_ACCOUNT_ID, (Object)builder.build());
            return this;
        }

        public Builder stakedNodeId(long stakedNodeId) {
            this.stakedId = new OneOf((Object)StakedIdOneOfType.STAKED_NODE_ID, (Object)stakedNodeId);
            return this;
        }

        public Builder declineReward(Boolean declineReward) {
            this.declineReward = declineReward;
            return this;
        }
    }
}

