/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract.codec;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.contract.ContractNonceInfo;
import com.hedera.hapi.node.contract.schema.ContractNonceInfoSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class ContractNonceInfoProtoCodec
implements Codec<ContractNonceInfo> {
    @NonNull
    public ContractNonceInfo parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public ContractNonceInfo parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull ContractNonceInfo data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ContractNonceInfoSchema.CONTRACT_ID, (Object)data.contractId(), (arg_0, arg_1) -> ContractID.PROTOBUF.write(arg_0, arg_1), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ContractNonceInfoSchema.NONCE, (long)data.nonce());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(ContractNonceInfo data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ContractNonceInfoSchema.CONTRACT_ID, (Object)data.contractId(), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        return size += ProtoWriterTools.sizeOfLong((FieldDefinition)ContractNonceInfoSchema.NONCE, (long)data.nonce());
    }

    public boolean fastEquals(@NonNull ContractNonceInfo item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private ContractNonceInfo parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        ContractID temp_contract_id = null;
        long temp_nonce = 0L;
        try {
            block6: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = ContractNonceInfoSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        ContractID value = strictMode ? (ContractID)ContractID.PROTOBUF.parseStrict(input) : (ContractID)ContractID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_contract_id = value;
                        continue block6;
                    }
                    case 16: {
                        long value;
                        temp_nonce = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block6;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new ContractNonceInfo(temp_contract_id, temp_nonce);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new ContractNonceInfo(temp_contract_id, temp_nonce);
    }
}

