/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract.codec;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.contract.EthereumTransactionBody;
import com.hedera.hapi.node.contract.schema.EthereumTransactionBodySchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class EthereumTransactionBodyProtoCodec
implements Codec<EthereumTransactionBody> {
    @NonNull
    public EthereumTransactionBody parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public EthereumTransactionBody parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull EthereumTransactionBody data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)EthereumTransactionBodySchema.ETHEREUM_DATA, (RandomAccessData)data.ethereumData());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)EthereumTransactionBodySchema.CALL_DATA, (Object)data.callData(), (arg_0, arg_1) -> FileID.PROTOBUF.write(arg_0, arg_1), arg_0 -> FileID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)EthereumTransactionBodySchema.MAX_GAS_ALLOWANCE, (long)data.maxGasAllowance());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(EthereumTransactionBody data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)EthereumTransactionBodySchema.ETHEREUM_DATA, (RandomAccessData)data.ethereumData());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)EthereumTransactionBodySchema.CALL_DATA, (Object)data.callData(), arg_0 -> FileID.PROTOBUF.measureRecord(arg_0));
        return size += ProtoWriterTools.sizeOfLong((FieldDefinition)EthereumTransactionBodySchema.MAX_GAS_ALLOWANCE, (long)data.maxGasAllowance());
    }

    public boolean fastEquals(@NonNull EthereumTransactionBody item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private EthereumTransactionBody parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Bytes temp_ethereum_data = Bytes.EMPTY;
        FileID temp_call_data = null;
        long temp_max_gas_allowance = 0L;
        try {
            block7: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = EthereumTransactionBodySchema.getField(field);
                switch (tag) {
                    case 10: {
                        Bytes value;
                        temp_ethereum_data = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block7;
                    }
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        FileID value = strictMode ? (FileID)FileID.PROTOBUF.parseStrict(input) : (FileID)FileID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_call_data = value;
                        continue block7;
                    }
                    case 24: {
                        long value;
                        temp_max_gas_allowance = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block7;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new EthereumTransactionBody(temp_ethereum_data, temp_call_data, temp_max_gas_allowance);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new EthereumTransactionBody(temp_ethereum_data, temp_call_data, temp_max_gas_allowance);
    }
}

