/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.file;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.file.codec.FileAppendTransactionBodyJsonCodec;
import com.hedera.hapi.node.file.codec.FileAppendTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record FileAppendTransactionBody(@Nullable FileID fileID, Bytes contents) {
    public static final Codec<FileAppendTransactionBody> PROTOBUF = new FileAppendTransactionBodyProtoCodec();
    public static final JsonCodec<FileAppendTransactionBody> JSON = new FileAppendTransactionBodyJsonCodec();
    public static final FileAppendTransactionBody DEFAULT = FileAppendTransactionBody.newBuilder().build();

    public boolean hasFileID() {
        return this.fileID != null;
    }

    public FileID fileIDOrElse(@NonNull FileID defaultValue) {
        return this.hasFileID() ? this.fileID : defaultValue;
    }

    @NonNull
    public FileID fileIDOrThrow() {
        return Objects.requireNonNull(this.fileID, "Field fileID is null");
    }

    public void ifFileID(@NonNull Consumer<FileID> ifPresent) {
        if (this.hasFileID()) {
            ifPresent.accept(this.fileID);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.fileID, this.contents);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private FileID fileID = null;
        private Bytes contents = Bytes.EMPTY;

        public Builder() {
        }

        public Builder(FileID fileID, Bytes contents) {
            this.fileID = fileID;
            this.contents = contents;
        }

        public FileAppendTransactionBody build() {
            return new FileAppendTransactionBody(this.fileID, this.contents);
        }

        public Builder fileID(FileID fileID) {
            this.fileID = fileID;
            return this;
        }

        public Builder fileID(FileID.Builder builder) {
            this.fileID = builder.build();
            return this;
        }

        public Builder contents(Bytes contents) {
            this.contents = contents;
            return this;
        }
    }
}

