/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.file;

import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.RealmID;
import com.hedera.hapi.node.base.ShardID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.file.codec.FileCreateTransactionBodyJsonCodec;
import com.hedera.hapi.node.file.codec.FileCreateTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record FileCreateTransactionBody(@Nullable Timestamp expirationTime, @Nullable KeyList keys, Bytes contents, @Nullable ShardID shardID, @Nullable RealmID realmID, @Nullable Key newRealmAdminKey, String memo) {
    public static final Codec<FileCreateTransactionBody> PROTOBUF = new FileCreateTransactionBodyProtoCodec();
    public static final JsonCodec<FileCreateTransactionBody> JSON = new FileCreateTransactionBodyJsonCodec();
    public static final FileCreateTransactionBody DEFAULT = FileCreateTransactionBody.newBuilder().build();

    public boolean hasExpirationTime() {
        return this.expirationTime != null;
    }

    public Timestamp expirationTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasExpirationTime() ? this.expirationTime : defaultValue;
    }

    @NonNull
    public Timestamp expirationTimeOrThrow() {
        return Objects.requireNonNull(this.expirationTime, "Field expirationTime is null");
    }

    public void ifExpirationTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasExpirationTime()) {
            ifPresent.accept(this.expirationTime);
        }
    }

    public boolean hasKeys() {
        return this.keys != null;
    }

    public KeyList keysOrElse(@NonNull KeyList defaultValue) {
        return this.hasKeys() ? this.keys : defaultValue;
    }

    @NonNull
    public KeyList keysOrThrow() {
        return Objects.requireNonNull(this.keys, "Field keys is null");
    }

    public void ifKeys(@NonNull Consumer<KeyList> ifPresent) {
        if (this.hasKeys()) {
            ifPresent.accept(this.keys);
        }
    }

    public boolean hasShardID() {
        return this.shardID != null;
    }

    public ShardID shardIDOrElse(@NonNull ShardID defaultValue) {
        return this.hasShardID() ? this.shardID : defaultValue;
    }

    @NonNull
    public ShardID shardIDOrThrow() {
        return Objects.requireNonNull(this.shardID, "Field shardID is null");
    }

    public void ifShardID(@NonNull Consumer<ShardID> ifPresent) {
        if (this.hasShardID()) {
            ifPresent.accept(this.shardID);
        }
    }

    public boolean hasRealmID() {
        return this.realmID != null;
    }

    public RealmID realmIDOrElse(@NonNull RealmID defaultValue) {
        return this.hasRealmID() ? this.realmID : defaultValue;
    }

    @NonNull
    public RealmID realmIDOrThrow() {
        return Objects.requireNonNull(this.realmID, "Field realmID is null");
    }

    public void ifRealmID(@NonNull Consumer<RealmID> ifPresent) {
        if (this.hasRealmID()) {
            ifPresent.accept(this.realmID);
        }
    }

    public boolean hasNewRealmAdminKey() {
        return this.newRealmAdminKey != null;
    }

    public Key newRealmAdminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasNewRealmAdminKey() ? this.newRealmAdminKey : defaultValue;
    }

    @NonNull
    public Key newRealmAdminKeyOrThrow() {
        return Objects.requireNonNull(this.newRealmAdminKey, "Field newRealmAdminKey is null");
    }

    public void ifNewRealmAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasNewRealmAdminKey()) {
            ifPresent.accept(this.newRealmAdminKey);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.expirationTime, this.keys, this.contents, this.shardID, this.realmID, this.newRealmAdminKey, this.memo);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Timestamp expirationTime = null;
        private KeyList keys = null;
        private Bytes contents = Bytes.EMPTY;
        private ShardID shardID = null;
        private RealmID realmID = null;
        private Key newRealmAdminKey = null;
        private String memo = "";

        public Builder() {
        }

        public Builder(Timestamp expirationTime, KeyList keys, Bytes contents, ShardID shardID, RealmID realmID, Key newRealmAdminKey, String memo) {
            this.expirationTime = expirationTime;
            this.keys = keys;
            this.contents = contents;
            this.shardID = shardID;
            this.realmID = realmID;
            this.newRealmAdminKey = newRealmAdminKey;
            this.memo = memo;
        }

        public FileCreateTransactionBody build() {
            return new FileCreateTransactionBody(this.expirationTime, this.keys, this.contents, this.shardID, this.realmID, this.newRealmAdminKey, this.memo);
        }

        public Builder expirationTime(Timestamp expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public Builder expirationTime(Timestamp.Builder builder) {
            this.expirationTime = builder.build();
            return this;
        }

        public Builder keys(KeyList keys) {
            this.keys = keys;
            return this;
        }

        public Builder keys(KeyList.Builder builder) {
            this.keys = builder.build();
            return this;
        }

        public Builder contents(Bytes contents) {
            this.contents = contents;
            return this;
        }

        public Builder shardID(ShardID shardID) {
            this.shardID = shardID;
            return this;
        }

        public Builder shardID(ShardID.Builder builder) {
            this.shardID = builder.build();
            return this;
        }

        public Builder realmID(RealmID realmID) {
            this.realmID = realmID;
            return this;
        }

        public Builder realmID(RealmID.Builder builder) {
            this.realmID = builder.build();
            return this;
        }

        public Builder newRealmAdminKey(Key newRealmAdminKey) {
            this.newRealmAdminKey = newRealmAdminKey;
            return this;
        }

        public Builder newRealmAdminKey(Key.Builder builder) {
            this.newRealmAdminKey = builder.build();
            return this;
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }
    }
}

