/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.file;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.file.codec.FileInfoJsonCodec;
import com.hedera.hapi.node.file.codec.FileInfoProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record FileInfo(@Nullable FileID fileID, long size, @Nullable Timestamp expirationTime, boolean deleted, @Nullable KeyList keys, String memo, Bytes ledgerId) {
    public static final Codec<FileInfo> PROTOBUF = new FileInfoProtoCodec();
    public static final JsonCodec<FileInfo> JSON = new FileInfoJsonCodec();
    public static final FileInfo DEFAULT = FileInfo.newBuilder().build();

    public boolean hasFileID() {
        return this.fileID != null;
    }

    public FileID fileIDOrElse(@NonNull FileID defaultValue) {
        return this.hasFileID() ? this.fileID : defaultValue;
    }

    @NonNull
    public FileID fileIDOrThrow() {
        return Objects.requireNonNull(this.fileID, "Field fileID is null");
    }

    public void ifFileID(@NonNull Consumer<FileID> ifPresent) {
        if (this.hasFileID()) {
            ifPresent.accept(this.fileID);
        }
    }

    public boolean hasExpirationTime() {
        return this.expirationTime != null;
    }

    public Timestamp expirationTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasExpirationTime() ? this.expirationTime : defaultValue;
    }

    @NonNull
    public Timestamp expirationTimeOrThrow() {
        return Objects.requireNonNull(this.expirationTime, "Field expirationTime is null");
    }

    public void ifExpirationTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasExpirationTime()) {
            ifPresent.accept(this.expirationTime);
        }
    }

    public boolean hasKeys() {
        return this.keys != null;
    }

    public KeyList keysOrElse(@NonNull KeyList defaultValue) {
        return this.hasKeys() ? this.keys : defaultValue;
    }

    @NonNull
    public KeyList keysOrThrow() {
        return Objects.requireNonNull(this.keys, "Field keys is null");
    }

    public void ifKeys(@NonNull Consumer<KeyList> ifPresent) {
        if (this.hasKeys()) {
            ifPresent.accept(this.keys);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.fileID, this.size, this.expirationTime, this.deleted, this.keys, this.memo, this.ledgerId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private FileID fileID = null;
        private long size = 0L;
        private Timestamp expirationTime = null;
        private boolean deleted = false;
        private KeyList keys = null;
        private String memo = "";
        private Bytes ledgerId = Bytes.EMPTY;

        public Builder() {
        }

        public Builder(FileID fileID, long size, Timestamp expirationTime, boolean deleted, KeyList keys, String memo, Bytes ledgerId) {
            this.fileID = fileID;
            this.size = size;
            this.expirationTime = expirationTime;
            this.deleted = deleted;
            this.keys = keys;
            this.memo = memo;
            this.ledgerId = ledgerId;
        }

        public FileInfo build() {
            return new FileInfo(this.fileID, this.size, this.expirationTime, this.deleted, this.keys, this.memo, this.ledgerId);
        }

        public Builder fileID(FileID fileID) {
            this.fileID = fileID;
            return this;
        }

        public Builder fileID(FileID.Builder builder) {
            this.fileID = builder.build();
            return this;
        }

        public Builder size(long size) {
            this.size = size;
            return this;
        }

        public Builder expirationTime(Timestamp expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public Builder expirationTime(Timestamp.Builder builder) {
            this.expirationTime = builder.build();
            return this;
        }

        public Builder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder keys(KeyList keys) {
            this.keys = keys;
            return this;
        }

        public Builder keys(KeyList.Builder builder) {
            this.keys = builder.build();
            return this;
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder ledgerId(Bytes ledgerId) {
            this.ledgerId = ledgerId;
            return this;
        }
    }
}

